/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.virtualfile.remote;

import be.bagofwords.util.WrappedSocketConnection;
import be.bagofwords.virtualfile.VirtualFile;
import be.bagofwords.virtualfile.remote.RemoteFileServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class RemoteFile
implements VirtualFile {
    private String host;
    private int port;
    private File relPath;

    public RemoteFile(String host, int port, File relPath) {
        this.host = host;
        this.port = port;
        this.relPath = relPath;
    }

    @Override
    public VirtualFile getFile(String relativePath) {
        File newRelPath = new File(this.relPath, relativePath);
        return new RemoteFile(this.host, this.port, newRelPath);
    }

    @Override
    public InputStream createInputStream() {
        try {
            WrappedSocketConnection connection = new WrappedSocketConnection(this.host, this.port);
            connection.writeByte((byte)RemoteFileServer.Action.INPUT_STREAM.ordinal());
            connection.writeString(this.relPath.getPath());
            connection.flush();
            long answer = connection.readLong();
            if (answer == 0x7FFFFFFFFFFFFFFEL) {
                return connection.getIs();
            }
            String message = connection.readString();
            throw new RuntimeException("Received unexpected response while creating input stream to " + this.host + ":" + this.port + " " + message);
        }
        catch (IOException exp) {
            throw new RuntimeException("Received exception while creating input stream to " + this.host + ":" + this.port, exp);
        }
    }

    @Override
    public OutputStream createOutputStream() {
        try {
            WrappedSocketConnection connection = new WrappedSocketConnection(this.host, this.port);
            connection.writeByte((byte)RemoteFileServer.Action.OUTPUT_STREAM.ordinal());
            connection.writeString(this.relPath.getPath());
            connection.flush();
            long answer = connection.readLong();
            if (answer == 0x7FFFFFFFFFFFFFFEL) {
                return connection.getOs();
            }
            String message = connection.readString();
            throw new RuntimeException("Received unexpected response while creating output stream to " + this.host + ":" + this.port + " " + message);
        }
        catch (IOException exp) {
            throw new RuntimeException("Received exception while creating output stream to " + this.host + ":" + this.port, exp);
        }
    }

    @Override
    public boolean exists() {
        boolean bl;
        WrappedSocketConnection connection = null;
        try {
            connection = new WrappedSocketConnection(this.host, this.port);
            connection.writeByte((byte)RemoteFileServer.Action.EXISTS.ordinal());
            connection.writeString(this.relPath.getPath());
            connection.flush();
            bl = connection.readBoolean();
        }
        catch (IOException exp) {
            try {
                throw new RuntimeException("Received exception while querying exists to " + this.host + ":" + this.port, exp);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)connection);
        return bl;
    }
}

