/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.virtualfile.local;

import be.bagofwords.virtualfile.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class LocalFile
implements VirtualFile {
    private final File file;

    public LocalFile(File file) {
        this.file = file;
    }

    @Override
    public VirtualFile getFile(String relativePath) {
        File newFile = new File(this.file, relativePath);
        newFile.getParentFile().mkdirs();
        return new LocalFile(newFile);
    }

    @Override
    public InputStream createInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to create inputstream for file " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public OutputStream createOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to create inputstream for file " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

