/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.virtualfile;

import be.bagofwords.util.SerializationUtils;
import be.bagofwords.virtualfile.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class VirtualFileService {
    public abstract VirtualFile getRootDirectory();

    public void storeSingleObject(String location, Object object) {
        VirtualFile file = this.getFile(location);
        try (OutputStream os = file.createOutputStream();){
            SerializationUtils.writeObject((Object)object, (OutputStream)os);
        }
        catch (IOException exp) {
            throw new RuntimeException("Unexpected exception while trying to write object to " + location);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readSingleObject(String location, Class<T> _class) {
        VirtualFile file = this.getFile(location);
        try (InputStream is = file.createInputStream();){
            Object object = SerializationUtils.readObject(_class, (InputStream)is);
            return (T)object;
        }
        catch (IOException exp) {
            throw new RuntimeException("Unexpected exception while trying to write object to " + location);
        }
    }

    private VirtualFile getFile(String location) {
        return this.getRootDirectory().getFile(location);
    }
}

