/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.util;

import be.bagofwords.ui.UI;
import be.bagofwords.util.SerializationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.CharUtils;

public class InspectFile {
    public static void main(String[] args) throws IOException {
        int length;
        byte[] buffer;
        File fileToInspect = new File(UI.read((String)"Please specify the file to inspect"));
        FileInputStream fis = new FileInputStream(fileToInspect);
        int bytesRead = fis.read(buffer = new byte[length = (int)fileToInspect.length()]);
        if (bytesRead != buffer.length) {
            throw new RuntimeException("Expected to read " + buffer.length + " but read " + bytesRead);
        }
        InspectFile.inspectBuffer(buffer);
    }

    private static void inspectBuffer(byte[] buffer) {
        ArrayList<ReadValue> values = new ArrayList<ReadValue>();
        boolean finished = false;
        while (!finished) {
            int action;
            while ((action = UI.readInt((String)("Inspecting buffer of length " + buffer.length + " Read (1) long, (2) int, (3) string or (4) stop"))) < 1 || action > 4) {
            }
            if (action == 4) {
                finished = true;
                continue;
            }
            int startPos = UI.readInt((String)"start position?");
            int endPos = -1;
            Object value = null;
            if (action == 1) {
                value = SerializationUtils.bytesToLong((byte[])buffer, (int)startPos);
                endPos = startPos + 8;
            } else if (action == 2) {
                value = SerializationUtils.bytesToInt((byte[])buffer, (int)startPos);
                endPos = startPos + 4;
            } else if (action == 3) {
                int length = UI.readInt((String)"length of string?");
                value = SerializationUtils.bytesToString((byte[])buffer, (int)startPos, (int)length);
                endPos = startPos + length;
            }
            for (int i = 0; i < values.size(); ++i) {
                ReadValue curr = (ReadValue)values.get(i);
                if (curr.getStart() >= endPos || startPos >= curr.getEnd()) continue;
                values.remove(i--);
            }
            values.add(new ReadValue(startPos, endPos, value));
            Collections.sort(values);
            InspectFile.printValues(values);
        }
    }

    private static void printValues(List<ReadValue> values) {
        for (ReadValue value : values) {
            Object valueToPrint = value.getValue();
            if (valueToPrint instanceof String) {
                String stringValueToPrint = (String)valueToPrint;
                if ((stringValueToPrint = InspectFile.replaceNonAscii(stringValueToPrint)).length() > 100) {
                    stringValueToPrint = stringValueToPrint.substring(0, 50) + " ... " + stringValueToPrint.substring(stringValueToPrint.length() - 50, stringValueToPrint.length());
                }
                valueToPrint = stringValueToPrint;
            }
            UI.write((String)(value.getStart() + "-->" + value.getEnd() + "=" + valueToPrint));
        }
    }

    private static String replaceNonAscii(String valueToPrint) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < valueToPrint.length(); ++i) {
            if (CharUtils.isAscii((char)valueToPrint.charAt(i))) {
                result.append(valueToPrint.charAt(i));
                continue;
            }
            result.append("?");
        }
        return result.toString();
    }

    private static class ReadValue
    implements Comparable<ReadValue> {
        private int start;
        private int end;
        private Object value;

        private ReadValue(int start, int end, Object value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public int compareTo(ReadValue o) {
            return Integer.compare(this.getStart(), o.getStart());
        }
    }
}

