/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.tests.uniform;

import be.bagofwords.db.DataInterface;
import be.bagofwords.util.SafeThread;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.mutable.MutableLong;

class UniformDataTestsThread
extends SafeThread {
    private final MutableLong numberOfItemsProcessed;
    private final long numberOfItems;
    private final DataInterface dataInterface;
    private CountDownLatch countDownLatch;
    private final boolean writeValues;

    public UniformDataTestsThread(MutableLong numberOfItemsProcessed, long numberOfItems, DataInterface dataInterface, CountDownLatch countDownLatch, boolean writeValues) {
        super("ReadTextThread", false);
        this.numberOfItemsProcessed = numberOfItemsProcessed;
        this.numberOfItems = numberOfItems;
        this.dataInterface = dataInterface;
        this.countDownLatch = countDownLatch;
        this.writeValues = writeValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInt() throws IOException {
        Random random = new Random();
        while (this.numberOfItemsProcessed.longValue() < this.numberOfItems) {
            long numberOfItemsPerIteration = this.numberOfItems / 10000L;
            int i = 0;
            while ((long)i < numberOfItemsPerIteration) {
                long value = random.nextInt(1000000);
                if (this.writeValues) {
                    this.dataInterface.increaseCount(value);
                } else {
                    this.dataInterface.readCount(value);
                }
                ++i;
            }
            MutableLong mutableLong = this.numberOfItemsProcessed;
            synchronized (mutableLong) {
                this.numberOfItemsProcessed.setValue(this.numberOfItemsProcessed.longValue() + numberOfItemsPerIteration);
            }
        }
        this.countDownLatch.countDown();
    }
}

