/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.tests.uniform;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.ApplicationManager;
import be.bagofwords.application.MainClass;
import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.combinator.LongCombinator;
import be.bagofwords.db.experimental.kyoto.KyotoDataInterfaceFactory;
import be.bagofwords.db.experimental.rocksdb.RocksDBDataInterfaceFactory;
import be.bagofwords.db.filedb.FileDataInterfaceFactory;
import be.bagofwords.db.leveldb.LevelDBDataInterfaceFactory;
import be.bagofwords.main.tests.TestsApplicationContextFactory;
import be.bagofwords.main.tests.uniform.UniformDataTestsThread;
import be.bagofwords.ui.UI;
import be.bagofwords.util.NumUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;

public class UniformDataTestsMain
implements MainClass {
    private static final int MIN_MILLION_ITEMS_TO_PROCESS = 1;
    private static final int MAX_MILLION_ITEMS_TO_PROCESS = 4096;
    private static final File tmpDbDir = new File("/tmp/testRandomCounts");
    @Autowired
    private CachesManager cachesManager;
    @Autowired
    private MemoryManager memoryManager;

    public static void main(String[] args) throws IOException, InterruptedException {
        ApplicationManager.runSafely((ApplicationContextFactory)new TestsApplicationContextFactory(new UniformDataTestsMain()));
    }

    public void run() {
        try {
            UniformDataTestsMain.prepareTmpDir(tmpDbDir);
            this.testWritingReading(new LevelDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/levelDB"), DatabaseCachingType.DIRECT);
            this.testWritingReading(new FileDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/fileDb"), DatabaseCachingType.CACHED_AND_BLOOM);
            this.testWritingReading(new KyotoDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/kyotoDB"), DatabaseCachingType.DIRECT);
            this.testWritingReading(new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBD", false), DatabaseCachingType.DIRECT);
            this.testWritingReading(new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBD", true), DatabaseCachingType.DIRECT);
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static void prepareTmpDir(File tmpDbDir) throws IOException {
        boolean success;
        if (tmpDbDir.exists()) {
            FileUtils.deleteDirectory((File)tmpDbDir);
        }
        if (!(success = tmpDbDir.mkdirs())) {
            throw new RuntimeException("Failed to create db dir " + tmpDbDir.getAbsolutePath());
        }
    }

    private void testWritingReading(DataInterfaceFactory factory, DatabaseCachingType type) throws InterruptedException, FileNotFoundException {
        for (long items = 0x100000L; items <= 0L; items *= 2L) {
            this.testBatchWritingAndReading(factory, type, 8, items);
        }
        factory.terminate();
    }

    private void testBatchWritingAndReading(DataInterfaceFactory factory, DatabaseCachingType cachingType, int numberOfThreads, long numberOfItems) throws FileNotFoundException, InterruptedException {
        DataInterface dataInterface = this.createDataInterface(cachingType, factory);
        dataInterface.dropAllData();
        MutableLong numberOfItemsWritten = new MutableLong(0L);
        long startOfWrite = System.nanoTime();
        CountDownLatch countDownLatch = new CountDownLatch(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            new UniformDataTestsThread(numberOfItemsWritten, numberOfItems, dataInterface, countDownLatch, true).start();
        }
        countDownLatch.await();
        dataInterface.flush();
        long endOfWrite = System.nanoTime();
        double writesPerSecond = (double)numberOfItemsWritten.longValue() * 1.0E9 / (double)(endOfWrite - startOfWrite);
        countDownLatch = new CountDownLatch(numberOfThreads);
        dataInterface.optimizeForReading();
        MutableLong numberOfItemsRead = new MutableLong(0L);
        long startOfRead = System.nanoTime();
        for (int i = 0; i < numberOfThreads; ++i) {
            new UniformDataTestsThread(numberOfItemsRead, numberOfItems, dataInterface, countDownLatch, false).start();
        }
        countDownLatch.await();
        long endOfRead = System.nanoTime();
        double readsPerSecond = (double)numberOfItemsRead.longValue() * 1.0E9 / (double)(endOfRead - startOfRead);
        UI.write((String)(factory.getClass().getSimpleName() + " threads " + numberOfThreads + " items " + numberOfItems + " write " + NumUtils.fmt((double)writesPerSecond) + " read " + NumUtils.fmt((double)readsPerSecond)));
        dataInterface.close();
    }

    protected DataInterface createDataInterface(DatabaseCachingType cachingType, DataInterfaceFactory factory) {
        String dataInterfaceName = "readWriteRandom_" + (Object)((Object)cachingType) + "_" + factory.getClass().getSimpleName();
        return factory.createDataInterface(cachingType, dataInterfaceName, Long.class, new LongCombinator());
    }
}

