/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.tests.bloomfilter;

import be.bagofwords.db.bloomfilter.LongBloomFilter;
import be.bagofwords.db.data.LongCountsBloomFilter;
import be.bagofwords.ui.UI;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;

public class TestBloomFiltersSpeed {
    private static final int NUM_OF_VALUES = 1000000;

    public static void main(String[] args) {
        LongBloomFilter bloomFilter1 = new LongBloomFilter(1000000L, 0.001);
        BloomFilter bloomFilter2 = BloomFilter.create((Funnel)new Funnel<Long>(){

            public void funnel(Long from, PrimitiveSink into) {
                into.putLong(from.longValue());
            }
        }, (int)1000000, (double)0.001);
        LongCountsBloomFilter bloomFilter3 = new LongCountsBloomFilter(1000000L, 0.001);
        UI.write((String)("Writing values for filter 1 took " + TestBloomFiltersSpeed.putValues(bloomFilter1)));
        UI.write((String)("Writing values for filter 2 took " + TestBloomFiltersSpeed.putValues((BloomFilter<Long>)bloomFilter2)));
        UI.write((String)("Writing values for filter 3 took " + TestBloomFiltersSpeed.putValues(bloomFilter3)));
        UI.write((String)("Reading values for filter 1 took " + TestBloomFiltersSpeed.readValues(bloomFilter1)));
        UI.write((String)("Reading values for filter 2 took " + TestBloomFiltersSpeed.readValues((BloomFilter<Long>)bloomFilter2)));
        UI.write((String)("Reading values for filter 3 took " + TestBloomFiltersSpeed.readValues(bloomFilter3)));
    }

    private static long readValues(LongBloomFilter bloomFilter1) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter1.mightContain(i);
        }
        return System.currentTimeMillis() - start;
    }

    private static long readValues(BloomFilter<Long> bloomFilter2) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter2.mightContain((Object)i);
        }
        return System.currentTimeMillis() - start;
    }

    private static long readValues(LongCountsBloomFilter bloomFilter3) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter3.getMaxCount(i);
        }
        return System.currentTimeMillis() - start;
    }

    private static long putValues(LongCountsBloomFilter bloomFilter3) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter3.addCount(i, 12);
        }
        return System.currentTimeMillis() - start;
    }

    private static long putValues(BloomFilter<Long> bloomFilter2) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter2.put((Object)i);
        }
        return System.currentTimeMillis() - start;
    }

    private static long putValues(LongBloomFilter bloomFilter1) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            if (i % 3 != 0) continue;
            bloomFilter1.put(i);
        }
        return System.currentTimeMillis() - start;
    }
}

