/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.tests.bigrams;

import be.bagofwords.db.DataInterface;
import be.bagofwords.main.tests.bigrams.BigramCount;
import be.bagofwords.main.tests.bigrams.DataType;
import be.bagofwords.text.WordIterator;
import be.bagofwords.util.HashUtils;
import be.bagofwords.util.SafeThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.mutable.MutableLong;

class BigramTestsThread
extends SafeThread {
    private final MutableLong numberOfItemsWritten;
    private final long numberOfItems;
    private final BufferedReader rdr;
    private final DataInterface dataInterface;
    private final DataType dataType;
    private CountDownLatch countDownLatch;
    private final boolean readData;

    public BigramTestsThread(DataType dataType, MutableLong numberOfItemsWritten, long numberOfItems, BufferedReader rdr, DataInterface dataInterface, CountDownLatch countDownLatch, boolean readData) {
        super("ReadTextThread", false);
        this.numberOfItemsWritten = numberOfItemsWritten;
        this.numberOfItems = numberOfItems;
        this.rdr = rdr;
        this.dataInterface = dataInterface;
        this.countDownLatch = countDownLatch;
        this.readData = readData;
        this.dataType = dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInt() throws IOException {
        char[] textBuffer = new char[200000];
        while (this.numberOfItemsWritten.longValue() < this.numberOfItems) {
            int charsRead;
            BufferedReader bufferedReader = this.rdr;
            synchronized (bufferedReader) {
                charsRead = this.rdr.read(textBuffer);
            }
            if (charsRead < 0) {
                throw new RuntimeException("Could not read the text");
            }
            long numOfWordsInText = 0L;
            char[] actualTextBuffer = charsRead < textBuffer.length ? Arrays.copyOf(textBuffer, charsRead) : textBuffer;
            WordIterator wordIterator = new WordIterator(actualTextBuffer, Collections.emptySet());
            String prev = null;
            while (wordIterator.hasNext()) {
                String word = wordIterator.next().toString().toLowerCase();
                if (prev != null) {
                    if (this.readData) {
                        if (this.dataType == DataType.LONG_COUNT) {
                            this.dataInterface.readCount(prev + " " + word);
                        } else {
                            this.dataInterface.read(HashUtils.hashCode((String)(prev + " " + word)));
                        }
                    } else if (this.dataType == DataType.LONG_COUNT) {
                        this.dataInterface.increaseCount(prev + " " + word);
                    } else {
                        this.dataInterface.write(HashUtils.hashCode((String)(prev + " " + word)), new BigramCount(prev, word));
                    }
                    ++numOfWordsInText;
                }
                prev = word;
            }
            MutableLong mutableLong = this.numberOfItemsWritten;
            synchronized (mutableLong) {
                this.numberOfItemsWritten.setValue(this.numberOfItemsWritten.longValue() + numOfWordsInText);
            }
        }
        this.countDownLatch.countDown();
    }
}

