/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main.tests.bigrams;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.ApplicationManager;
import be.bagofwords.application.MainClass;
import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.combinator.LongCombinator;
import be.bagofwords.db.experimental.kyoto.KyotoDataInterfaceFactory;
import be.bagofwords.db.experimental.rocksdb.RocksDBDataInterfaceFactory;
import be.bagofwords.db.filedb.FileDataInterfaceFactory;
import be.bagofwords.db.leveldb.LevelDBDataInterfaceFactory;
import be.bagofwords.main.tests.TestsApplicationContextFactory;
import be.bagofwords.main.tests.bigrams.BigramCount;
import be.bagofwords.main.tests.bigrams.BigramCountCombinator;
import be.bagofwords.main.tests.bigrams.BigramTestsThread;
import be.bagofwords.main.tests.bigrams.DataType;
import be.bagofwords.ui.UI;
import be.bagofwords.util.NumUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;

public class BigramTestsMain
implements MainClass {
    private static final long MIN_MILLION_ITEMS_TO_PROCESS = 1L;
    private static final long MAX_MILLION_ITEMS_TO_PROCESS = 4096L;
    private static final File tmpDbDir = new File("/tmp/testBigramCounts");
    @Autowired
    private CachesManager cachesManager;
    @Autowired
    private MemoryManager memoryManager;
    private final File largeTextFile;

    public BigramTestsMain(File largeTextFile) {
        this.largeTextFile = largeTextFile;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length != 1) {
            UI.writeError((String)"Please provide the path to a large text file");
        } else {
            ApplicationManager.runSafely((ApplicationContextFactory)new TestsApplicationContextFactory(new BigramTestsMain(new File(args[0]))));
        }
    }

    public void run() {
        try {
            UI.write((String)("Reading " + this.largeTextFile.getAbsolutePath()));
            BigramTestsMain.prepareTmpDir(tmpDbDir);
            this.runAllTests(DataType.LONG_COUNT);
            this.runAllTests(DataType.SERIALIZED_OBJECT);
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private void runAllTests(DataType dataType) throws InterruptedException, FileNotFoundException {
        UI.write((String)("Testing batch writing / reading for data type " + (Object)((Object)dataType)));
        this.testSeparateWritingReading(dataType, new LevelDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/levelDB"), DatabaseCachingType.DIRECT);
        this.testSeparateWritingReading(dataType, new FileDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/fileDb"), DatabaseCachingType.CACHED_AND_BLOOM);
        this.testSeparateWritingReading(dataType, new KyotoDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/kyotoDB"), DatabaseCachingType.DIRECT);
        this.testSeparateWritingReading(dataType, new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBD", false), DatabaseCachingType.DIRECT);
        this.testSeparateWritingReading(dataType, new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBDPatched", true), DatabaseCachingType.DIRECT);
        UI.write((String)("Testing mixed writing / reading for data type " + (Object)((Object)dataType)));
        this.testMixedWritingReading(dataType, new LevelDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/levelDB"), DatabaseCachingType.DIRECT);
        this.testMixedWritingReading(dataType, new FileDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/fileDb"), DatabaseCachingType.CACHED_AND_BLOOM);
        this.testMixedWritingReading(dataType, new KyotoDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/kyotoDB"), DatabaseCachingType.DIRECT);
        this.testMixedWritingReading(dataType, new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBD", false), DatabaseCachingType.DIRECT);
        this.testMixedWritingReading(dataType, new RocksDBDataInterfaceFactory(this.cachesManager, this.memoryManager, tmpDbDir.getAbsolutePath() + "/rocksBDPatched", true), DatabaseCachingType.DIRECT);
    }

    private static void prepareTmpDir(File tmpDbDir) throws IOException {
        boolean success;
        if (tmpDbDir.exists()) {
            FileUtils.deleteDirectory((File)tmpDbDir);
        }
        if (!(success = tmpDbDir.mkdirs())) {
            throw new RuntimeException("Failed to create db dir " + tmpDbDir.getAbsolutePath());
        }
    }

    private void testSeparateWritingReading(DataType dataType, DataInterfaceFactory factory, DatabaseCachingType type) throws InterruptedException, FileNotFoundException {
        for (long items = 0x100000L; items <= 0x100000000L; items *= 2L) {
            this.testSeparateWritingReading(dataType, factory, type, this.largeTextFile, 8, items);
        }
        factory.terminate();
    }

    private void testSeparateWritingReading(DataType dataType, DataInterfaceFactory factory, DatabaseCachingType cachingType, File largeTextFile, int numberOfThreads, long numberOfItems) throws FileNotFoundException, InterruptedException {
        DataInterface dataInterface = this.createDataInterface(dataType, cachingType, factory);
        dataInterface.dropAllData();
        BufferedReader rdr = new BufferedReader(new FileReader(largeTextFile));
        MutableLong numberOfItemsWritten = new MutableLong(0L);
        CountDownLatch writeLatch = new CountDownLatch(numberOfThreads);
        long startOfWrite = System.nanoTime();
        for (int i = 0; i < numberOfThreads; ++i) {
            new BigramTestsThread(dataType, numberOfItemsWritten, numberOfItems, rdr, dataInterface, writeLatch, false).start();
        }
        writeLatch.await();
        dataInterface.flush();
        long endOfWrite = System.nanoTime();
        double writesPerSecond = (double)numberOfItemsWritten.longValue() * 1.0E9 / (double)(endOfWrite - startOfWrite);
        dataInterface.optimizeForReading();
        MutableLong numberOfItemsRead = new MutableLong(0L);
        CountDownLatch readLatch = new CountDownLatch(numberOfThreads);
        long startOfRead = System.nanoTime();
        for (int i = 0; i < numberOfThreads; ++i) {
            new BigramTestsThread(dataType, numberOfItemsRead, Math.min(0xC800000L, numberOfItems), rdr, dataInterface, readLatch, true).start();
        }
        readLatch.await();
        dataInterface.flush();
        long endOfRead = System.nanoTime();
        double readsPerSecond = (double)numberOfItemsRead.longValue() * 1.0E9 / (double)(endOfRead - startOfRead);
        dataInterface.close();
        UI.write((String)(factory.getClass().getSimpleName() + " threads " + numberOfThreads + " items " + numberOfItems + " write " + NumUtils.fmt((double)writesPerSecond) + " read " + NumUtils.fmt((double)readsPerSecond)));
    }

    private void testMixedWritingReading(DataType dataType, DataInterfaceFactory factory, DatabaseCachingType type) throws InterruptedException, FileNotFoundException {
        for (long items = 0x100000L; items <= 0x100000000L; items *= 2L) {
            this.testMixedWritingReading(dataType, factory, type, this.largeTextFile, 8, items);
        }
        factory.terminate();
    }

    private void testMixedWritingReading(DataType dataType, DataInterfaceFactory factory, DatabaseCachingType cachingType, File largeTextFile, int numberOfThreads, long numberOfItems) throws FileNotFoundException, InterruptedException {
        DataInterface dataInterface = this.createDataInterface(dataType, cachingType, factory);
        dataInterface.dropAllData();
        BufferedReader rdr = new BufferedReader(new FileReader(largeTextFile));
        MutableLong numberOfItemsWritten = new MutableLong(0L);
        CountDownLatch writeLatch = new CountDownLatch(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            new BigramTestsThread(dataType, numberOfItemsWritten, numberOfItems, rdr, dataInterface, writeLatch, false).start();
        }
        writeLatch.await();
        dataInterface.flush();
        dataInterface.optimizeForReading();
        MutableLong numberOfItemsRead = new MutableLong(0L);
        numberOfItemsWritten = new MutableLong(0L);
        CountDownLatch readLatch = new CountDownLatch(numberOfThreads / 2);
        writeLatch = new CountDownLatch(numberOfThreads / 2);
        long start = System.nanoTime();
        for (int i = 0; i < numberOfThreads; ++i) {
            boolean isReadThread = i % 2 == 0;
            new BigramTestsThread(dataType, isReadThread ? numberOfItemsRead : numberOfItemsWritten, Math.min(0x6400000L, numberOfItems), rdr, dataInterface, isReadThread ? readLatch : writeLatch, isReadThread).start();
        }
        readLatch.await();
        long endOfRead = System.nanoTime();
        writeLatch.await();
        dataInterface.flush();
        long endOfWrite = System.nanoTime();
        double readsPerSecond = (double)numberOfItemsRead.longValue() * 1.0E9 / (double)(endOfRead - start);
        double writesPerSecond = (double)numberOfItemsWritten.longValue() * 1.0E9 / (double)(endOfWrite - start);
        dataInterface.close();
        UI.write((String)(factory.getClass().getSimpleName() + " threads " + numberOfThreads + " items " + numberOfItems + " write " + NumUtils.fmt((double)writesPerSecond) + " read " + NumUtils.fmt((double)readsPerSecond)));
    }

    protected DataInterface createDataInterface(DataType dataType, DatabaseCachingType cachingType, DataInterfaceFactory factory) {
        String dataInterfaceName = "readWriteBigrams_" + (Object)((Object)dataType) + "_" + (Object)((Object)cachingType) + "_" + factory.getClass().getSimpleName();
        switch (dataType) {
            case LONG_COUNT: {
                return factory.createDataInterface(cachingType, dataInterfaceName, Long.class, new LongCombinator());
            }
            case SERIALIZED_OBJECT: {
                return factory.createDataInterface(cachingType, dataInterfaceName, BigramCount.class, new BigramCountCombinator());
            }
        }
        throw new RuntimeException("Unknown data type " + (Object)((Object)dataType));
    }
}

