/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main;

import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.application.EmbeddedDBContextFactory;
import be.bagofwords.db.combinator.OverWriteCombinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.KeyValue;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class ExampleUsage {
    public static void main(String[] args) throws ParseException {
        DataInterfaceFactory dataInterfaceFactory = (DataInterfaceFactory)new EmbeddedDBContextFactory("/tmp/myData").createApplicationContext().getBean(DataInterfaceFactory.class);
        DataInterface<Long> myLogDataInterface = dataInterfaceFactory.createCountDataInterface("myLoginCounts");
        DataInterface<UserObject> myUserDataInterface = dataInterfaceFactory.createDataInterface(DatabaseCachingType.CACHED, "myUsers", UserObject.class, new OverWriteCombinator());
        long userId = 12939L;
        myLogDataInterface.increaseCount("user_" + userId + "_logged_in");
        myUserDataInterface.write(userId, new UserObject("koen", "deschacht", DateUtils.parseDate((String)"1983-04-12", (String[])new String[]{"yyyy-MM-dd"})));
        myLogDataInterface.flush();
        myUserDataInterface.flush();
        long numOfLogins = myLogDataInterface.readCount("user_" + userId + "_logged_in");
        UserObject user = myUserDataInterface.read(userId);
        System.out.println("User " + user.getFirstName() + " " + user.getLastName() + " logged in " + numOfLogins + " times.");
        CloseableIterator<KeyValue<UserObject>> iterator = myUserDataInterface.iterator();
        while (iterator.hasNext()) {
            KeyValue curr = (KeyValue)iterator.next();
            UserObject currUser = (UserObject)curr.getValue();
            long currUserId = curr.getKey();
            System.out.println("User " + currUser.getFirstName() + " " + currUser.getLastName() + " with id " + currUserId);
        }
        iterator.close();
        myLogDataInterface.dropAllData();
        myUserDataInterface.dropAllData();
    }

    public static class UserObject {
        private String firstName;
        private String lastName;
        private Date dateOfBirth;

        public UserObject(String firstName, String lastName, Date dateOfBirth) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.dateOfBirth = dateOfBirth;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public Date getDateOfBirth() {
            return this.dateOfBirth;
        }

        public void setDateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
        }

        public UserObject() {
        }
    }
}

