/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.main;

import be.bagofwords.application.ApplicationContextFactory;
import be.bagofwords.application.ApplicationManager;
import be.bagofwords.application.BaseRunnableApplicationContextFactory;
import be.bagofwords.application.EnvironmentProperties;
import be.bagofwords.application.MainClass;
import be.bagofwords.application.status.ListUrlsController;
import be.bagofwords.application.status.RegisterUrlsClient;
import be.bagofwords.application.status.RemoteRegisterUrlsServerProperties;
import be.bagofwords.db.application.environment.FileCountDBEnvironmentProperties;
import be.bagofwords.db.application.environment.RemoteCountDBEnvironmentProperties;
import be.bagofwords.db.filedb.FileDataInterfaceFactory;
import be.bagofwords.db.remote.RemoteDataInterfaceServer;
import be.bagofwords.ui.UI;
import be.bagofwords.virtualfile.local.LocalFileService;
import be.bagofwords.virtualfile.remote.RemoteFileServer;
import be.bagofwords.web.WebContainerConfiguration;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class DatabaseServerMain
implements MainClass {
    @Autowired
    private RemoteDataInterfaceServer remoteDataInterfaceServer;
    @Autowired
    private RemoteFileServer remoteFileServer;
    @Autowired
    private ListUrlsController listUrlsController;

    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            UI.writeError((String)"Expected exactly 4 arguments, the directory to store the data files (e.g. /home/some_user/data/), the url of this server (e.g. www.myawesomeserver.com) the port of the data interface server (e.g. 1208) and the port of the virtual file server (e.g. 1209)");
        } else {
            String dataDirectory = args[0];
            String serverUrl = args[1];
            int dataInterfacePort = Integer.parseInt(args[2]);
            int virtualFileServerPort = Integer.parseInt(args[3]);
            ApplicationManager.runSafely((ApplicationContextFactory)new DatabaseServerMainContextFactory(new DatabaseServerMain(), dataDirectory, serverUrl, dataInterfacePort, virtualFileServerPort));
        }
    }

    public void run() {
        this.remoteDataInterfaceServer.start();
        this.remoteFileServer.start();
        this.remoteDataInterfaceServer.waitForFinish();
        this.remoteFileServer.waitForFinish();
    }

    public static class DatabaseServerMainContextFactory
    extends BaseRunnableApplicationContextFactory {
        private final EnvironmentProperties environmentProperties;

        public DatabaseServerMainContextFactory(DatabaseServerMain databaseServerMainClass, String dataDirectory, String serverUrl, int dataInterfacePort, int virtualFileServerPort) {
            super((MainClass)databaseServerMainClass);
            this.environmentProperties = new DatabaseServerMainEnvironmentProperties(dataDirectory, serverUrl, dataInterfacePort, virtualFileServerPort);
        }

        public AnnotationConfigApplicationContext createApplicationContext() {
            this.scan("be.bagofwords");
            this.bean(WebContainerConfiguration.class);
            this.singleton("environmentProperties", this.environmentProperties);
            this.bean(FileDataInterfaceFactory.class);
            this.bean(LocalFileService.class);
            this.bean(RegisterUrlsClient.class);
            return super.createApplicationContext();
        }
    }

    public static class DatabaseServerMainEnvironmentProperties
    implements FileCountDBEnvironmentProperties,
    RemoteCountDBEnvironmentProperties,
    RemoteRegisterUrlsServerProperties {
        private final String dataDirectory;
        private final String serverUrl;
        private final int dataInterfacePort;
        private final int virtualFileServerPort;

        public DatabaseServerMainEnvironmentProperties(String dataDirectory, String serverUrl, int dataInterfacePort, int virtualFileServerPort) {
            this.dataDirectory = dataDirectory;
            this.serverUrl = serverUrl;
            this.dataInterfacePort = dataInterfacePort;
            this.virtualFileServerPort = virtualFileServerPort;
        }

        @Override
        public String getDataDirectory() {
            return this.dataDirectory;
        }

        public boolean saveThreadSamplesToFile() {
            return true;
        }

        public String getThreadSampleLocation() {
            return this.dataDirectory + "/perf";
        }

        @Override
        public String getDatabaseServerAddress() {
            return "localhost";
        }

        public int getRegisterUrlServerPort() {
            return 1210;
        }

        @Override
        public int getDataInterfaceServerPort() {
            return this.dataInterfacePort;
        }

        @Override
        public int getVirtualFileServerPort() {
            return this.virtualFileServerPort;
        }

        public String getApplicationUrlRoot() {
            return this.serverUrl;
        }
    }
}

