/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.remote;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.application.environment.RemoteCountDBEnvironmentProperties;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.remote.RemoteDataInterface;
import be.bagofwords.db.remote.RemoteDataInterfaceServer;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.WrappedSocketConnection;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteDatabaseInterfaceFactory
extends DataInterfaceFactory {
    private final String host;
    private final int port;
    private Map<String, DataInterface> dataInterfaceMap;
    private ChangedValueListenerThread changedValueListenerThread;

    @Autowired
    public RemoteDatabaseInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, RemoteCountDBEnvironmentProperties environmentProperties) {
        this(cachesManager, memoryManager, environmentProperties.getDatabaseServerAddress(), environmentProperties.getDataInterfaceServerPort());
    }

    public RemoteDatabaseInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, String host, int port) {
        super(cachesManager, memoryManager);
        this.host = host;
        this.port = port;
        this.dataInterfaceMap = new HashMap<String, DataInterface>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized <T> DataInterface<T> createBaseDataInterface(String nameOfSubset, Class<T> objectClass, Combinator<T> combinator) {
        if (this.changedValueListenerThread == null) {
            RemoteDatabaseInterfaceFactory remoteDatabaseInterfaceFactory = this;
            synchronized (remoteDatabaseInterfaceFactory) {
                try {
                    this.changedValueListenerThread = new ChangedValueListenerThread();
                    this.changedValueListenerThread.start();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected exception while starting changedValueListenerThread", e);
                }
            }
        }
        RemoteDataInterface<T> result = new RemoteDataInterface<T>(nameOfSubset, objectClass, combinator, this.host, this.port);
        this.dataInterfaceMap.put(nameOfSubset, result);
        return result;
    }

    @Override
    public synchronized void terminate() {
        if (this.changedValueListenerThread != null) {
            this.changedValueListenerThread.terminateAndWaitForFinish();
        }
        super.terminate();
    }

    private class ChangedValueListenerThread
    extends SafeThread {
        private WrappedSocketConnection connection;

        public ChangedValueListenerThread() throws IOException {
            super("ChangedValueListener", false);
            this.connection = new WrappedSocketConnection(RemoteDatabaseInterfaceFactory.this.host, RemoteDatabaseInterfaceFactory.this.port);
        }

        protected void runInt() throws Exception {
            block5: {
                this.connection.writeByte((byte)RemoteDataInterfaceServer.Action.LISTEN_TO_CHANGES.ordinal());
                this.connection.flush();
                try {
                    while (!this.isTerminateRequested()) {
                        String interfaceName = this.connection.readString();
                        int numOfKeys = this.connection.readInt();
                        long[] keys = new long[numOfKeys];
                        for (int i = 0; i < numOfKeys; ++i) {
                            keys[i] = this.connection.readLong();
                        }
                        DataInterface dataInterface = (DataInterface)RemoteDatabaseInterfaceFactory.this.dataInterfaceMap.get(interfaceName);
                        if (dataInterface != null) {
                            dataInterface.notifyListenersOfChangedValues(keys);
                        }
                        this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
                        this.connection.flush();
                    }
                }
                catch (SocketException exp) {
                    if (exp.getMessage().equals("Socket closed")) break block5;
                    UI.writeError((String)"Error in ChangedValueListener", (Throwable)exp);
                }
            }
            IOUtils.closeQuietly((Closeable)this.connection);
        }

        protected void doTerminate() {
            IOUtils.closeQuietly((Closeable)this.connection);
        }
    }
}

