/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.remote;

import be.bagofwords.application.BaseServer;
import be.bagofwords.application.annotations.BowComponent;
import be.bagofwords.application.status.StatusViewable;
import be.bagofwords.db.ChangedValuesListener;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.application.environment.RemoteCountDBEnvironmentProperties;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.iterator.IterableUtils;
import be.bagofwords.iterator.SimpleIterator;
import be.bagofwords.ui.UI;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.NumUtils;
import be.bagofwords.util.ReflectionUtils;
import be.bagofwords.util.WrappedSocketConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

@BowComponent
public class RemoteDataInterfaceServer
extends BaseServer
implements StatusViewable {
    private final DataInterfaceFactory dataInterfaceFactory;
    private final List<WrappedSocketConnection> listenToChangesConnections;

    @Autowired
    public RemoteDataInterfaceServer(DataInterfaceFactory dataInterfaceFactory, RemoteCountDBEnvironmentProperties properties) throws IOException {
        super("RemoteDataInterfaceServer", properties.getDataInterfaceServerPort());
        this.dataInterfaceFactory = dataInterfaceFactory;
        this.listenToChangesConnections = new ArrayList<WrappedSocketConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseServer.SocketRequestHandler createSocketRequestHandler(WrappedSocketConnection connection) throws IOException {
        Action action = Action.values()[connection.readByte()];
        if (action == Action.CONNECT_TO_INTERFACE) {
            return new DataInterfaceSocketRequestHandler(connection);
        }
        if (action == Action.LISTEN_TO_CHANGES) {
            List<WrappedSocketConnection> list = this.listenToChangesConnections;
            synchronized (list) {
                this.listenToChangesConnections.add(connection);
            }
            return null;
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valuesChangedForInterface(String interfaceName, long[] keys) {
        List<WrappedSocketConnection> list = this.listenToChangesConnections;
        synchronized (list) {
            for (int i = 0; i < this.listenToChangesConnections.size(); ++i) {
                WrappedSocketConnection connection = this.listenToChangesConnections.get(i);
                try {
                    connection.writeString(interfaceName);
                    connection.writeInt(keys.length);
                    long[] lArray = keys;
                    int n = lArray.length;
                    for (int j = 0; j < n; ++j) {
                        Long key = lArray[j];
                        connection.writeLong(key.longValue());
                    }
                    connection.flush();
                    long response = connection.readLong();
                    if (response == 0x7FFFFFFFFFFFFFFEL) continue;
                    throw new RuntimeException("Unexpected response " + response + " from " + connection.getInetAddress());
                }
                catch (IOException exp) {
                    IOUtils.closeQuietly((Closeable)connection);
                    this.listenToChangesConnections.remove(i--);
                }
            }
        }
    }

    public void doTerminate() {
        super.doTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printHtmlStatus(StringBuilder sb) {
        ArrayList sortedRequestHandlers;
        sb.append("<h1>Printing database server statistics</h1>");
        this.ln(sb, "<table>");
        this.ln(sb, "<tr><td>Used memory is </td><td>" + UI.getMemoryUsage() + "</td></tr>");
        this.ln(sb, "<tr><td>Total number of connections </td><td>" + this.getTotalNumberOfConnections() + "</td></tr>");
        List runningRequestHandlers = this.getRunningRequestHandlers();
        this.ln(sb, "<tr><td>Current number of handlers </td><td>" + runningRequestHandlers.size() + "</td></tr>");
        List list = runningRequestHandlers;
        synchronized (list) {
            sortedRequestHandlers = new ArrayList(runningRequestHandlers);
        }
        Collections.sort(sortedRequestHandlers, new Comparator<BaseServer.SocketRequestHandler>(){

            @Override
            public int compare(BaseServer.SocketRequestHandler o1, BaseServer.SocketRequestHandler o2) {
                return -Double.compare(o1.getTotalNumberOfRequests(), o2.getTotalNumberOfRequests());
            }
        });
        for (int i = 0; i < sortedRequestHandlers.size(); ++i) {
            DataInterfaceSocketRequestHandler handler = (DataInterfaceSocketRequestHandler)((Object)sortedRequestHandlers.get(i));
            this.ln(sb, "<tr><td>" + i + " subset </td><td>" + handler.getDataInterface().getName() + "</td></tr>");
            this.ln(sb, "<tr><td>" + i + " Started at </td><td>" + new Date(handler.getStartTime()) + "</td></tr>");
            this.ln(sb, "<tr><td>" + i + " Total number of requests </td><td>" + handler.getTotalNumberOfRequests() + "</td></tr>");
            double requestsPerSec = (double)handler.getTotalNumberOfRequests() * 1000.0 / (double)(System.currentTimeMillis() - handler.getStartTime());
            this.ln(sb, "<tr><td>" + i + " Average requests/s</td><td>" + NumUtils.fmt((double)requestsPerSec) + "</td></tr>");
        }
        this.ln(sb, "</table>");
    }

    private void ln(StringBuilder sb, String s) {
        sb.append(s);
        sb.append("\n");
    }

    public static enum Action {
        READVALUE,
        WRITEVALUE,
        READVALUES,
        READKEYS,
        WRITEVALUES,
        DROPALLDATA,
        CLOSE_CONNECTION,
        FLUSH,
        READALLVALUES,
        APPROXIMATE_SIZE,
        MIGHT_CONTAIN,
        EXACT_SIZE,
        LISTEN_TO_CHANGES,
        CONNECT_TO_INTERFACE,
        OPTMIZE_FOR_READING;

    }

    public class DataInterfaceSocketRequestHandler
    extends BaseServer.SocketRequestHandler {
        private DataInterface dataInterface;
        private long startTime;
        private long totalNumberOfRequests;

        private DataInterfaceSocketRequestHandler(WrappedSocketConnection wrappedSocketConnection) throws IOException {
            super((BaseServer)RemoteDataInterfaceServer.this, wrappedSocketConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareHandler() throws Exception {
            this.startTime = System.currentTimeMillis();
            final String interfaceName = this.connection.readString();
            Class objectClass = this.readClass();
            Class combinatorClass = this.readClass();
            Combinator combinator = (Combinator)ReflectionUtils.createObject((Class)combinatorClass);
            List<DataInterface> list = RemoteDataInterfaceServer.this.dataInterfaceFactory.getAllInterfaces();
            synchronized (list) {
                this.dataInterface = this.findInterface(RemoteDataInterfaceServer.this.dataInterfaceFactory.getAllInterfaces(), interfaceName);
                if (this.dataInterface != null) {
                    if (this.dataInterface.getCombinator().getClass() != combinator.getClass() || this.dataInterface.getObjectClass() != objectClass) {
                        this.writeError(" Data interface " + interfaceName + " was already initialized!");
                    } else if (this.dataInterface.wasClosed()) {
                        this.writeError(" Data interface " + interfaceName + " was closed!");
                    }
                } else {
                    this.dataInterface = RemoteDataInterfaceServer.this.dataInterfaceFactory.createDataInterface(DatabaseCachingType.CACHED, interfaceName, objectClass, combinator);
                    this.dataInterface.registerListener(new ChangedValuesListener(){

                        @Override
                        public void valuesChanged(long[] keys) {
                            RemoteDataInterfaceServer.this.valuesChangedForInterface(interfaceName, keys);
                        }
                    });
                }
            }
            this.setName(this.getName() + "_" + this.dataInterface.getName());
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
            this.connection.flush();
        }

        private DataInterface findInterface(List<DataInterface> allInterfaces, String interfaceName) {
            for (DataInterface dataInterface : allInterfaces) {
                if (!dataInterface.getName().equals(interfaceName)) continue;
                return dataInterface;
            }
            return null;
        }

        protected void handleRequests() throws Exception {
            this.prepareHandler();
            this.connection.getOs().flush();
            boolean keepReadingCommands = true;
            while (keepReadingCommands && !this.isTerminateRequested()) {
                keepReadingCommands = this.handleRequest();
                ++this.totalNumberOfRequests;
                this.connection.getOs().flush();
            }
        }

        private boolean handleRequest() throws Exception {
            Action action = this.readNextAction();
            if (action == Action.CLOSE_CONNECTION) {
                this.terminate();
            } else if (action == Action.EXACT_SIZE) {
                this.handleExactSize();
            } else if (action == Action.APPROXIMATE_SIZE) {
                this.handleApproximateSize();
            } else if (action == Action.READVALUE) {
                this.handleReadValue();
            } else if (action == Action.WRITEVALUE) {
                this.handleWriteValue();
            } else if (action == Action.READALLVALUES) {
                this.handleReadAllValues();
            } else if (action == Action.READVALUES) {
                this.handleReadValues();
            } else if (action == Action.WRITEVALUES) {
                this.handleWriteValues();
            } else if (action == Action.READKEYS) {
                this.handleReadKeys();
            } else if (action == Action.DROPALLDATA) {
                this.handleDropAllData();
            } else if (action == Action.FLUSH) {
                this.handleFlush();
            } else if (action == Action.MIGHT_CONTAIN) {
                this.handleMightContain();
            } else if (action == Action.OPTMIZE_FOR_READING) {
                this.handleOptimizeForReading();
            } else {
                this.writeError("Unkown action " + (Object)((Object)action));
                return false;
            }
            return true;
        }

        private Action readNextAction() throws IOException {
            byte actionAsByte = this.connection.readByte();
            return Action.values()[actionAsByte];
        }

        public long getTotalNumberOfRequests() {
            return this.totalNumberOfRequests;
        }

        protected void reportUnexpectedError(Exception ex) {
            if (this.dataInterface != null) {
                UI.writeError((String)("Unexpected exception in request handler for data interface " + this.dataInterface.getName()), (Throwable)ex);
            } else {
                UI.writeError((String)"Unexpected exception in request handler", (Throwable)ex);
            }
        }

        public DataInterface getDataInterface() {
            return this.dataInterface;
        }

        public long getStartTime() {
            return this.startTime;
        }

        private void handleReadValues() throws IOException {
            CloseableIterator valueIt = this.dataInterface.iterator((Iterator<Long>)IterableUtils.iterator((SimpleIterator)new SimpleIterator<Long>(){

                public Long next() throws Exception {
                    return DataInterfaceSocketRequestHandler.this.connection.readLong();
                }
            }, (Object)0x7FFFFFFFFFFFFFFDL));
            try {
                while (valueIt.hasNext()) {
                    KeyValue value = (KeyValue)valueIt.next();
                    this.connection.writeLong(value.getKey());
                    this.connection.writeValue(value.getValue(), this.dataInterface.getObjectClass());
                }
                this.connection.writeLong(0x7FFFFFFFFFFFFFFDL);
            }
            finally {
                IOUtils.closeQuietly(valueIt);
            }
        }

        private void writeError(String errorMessage) throws IOException {
            this.connection.writeLong(Long.MAX_VALUE);
            this.connection.writeString(errorMessage);
        }

        private void handleFlush() throws IOException {
            this.dataInterface.flush();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
        }

        private void handleApproximateSize() throws IOException {
            long appSize = this.dataInterface.apprSize();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
            this.connection.writeLong(appSize);
        }

        private void handleExactSize() throws IOException {
            long exactSize = this.dataInterface.exactSize();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
            this.connection.writeLong(exactSize);
        }

        private void handleDropAllData() throws IOException {
            this.dataInterface.dropAllData();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
        }

        private void handleOptimizeForReading() throws IOException {
            this.dataInterface.optimizeForReading();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
        }

        private void handleWriteValues() throws IOException {
            this.dataInterface.write(new Iterator<KeyValue>(){
                private KeyValue nextValue;
                {
                    this.readNextValue();
                }

                private void readNextValue() {
                    try {
                        long key = DataInterfaceSocketRequestHandler.this.connection.readLong();
                        if (key == 0x7FFFFFFFFFFFFFFDL) {
                            this.nextValue = null;
                        } else {
                            Object value = DataInterfaceSocketRequestHandler.this.connection.readValue(DataInterfaceSocketRequestHandler.this.dataInterface.getObjectClass());
                            this.nextValue = new KeyValue(key, value);
                        }
                    }
                    catch (IOException exp) {
                        throw new RuntimeException("Received exception while reading list of values", exp);
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.nextValue != null;
                }

                @Override
                public KeyValue next() {
                    KeyValue result = this.nextValue;
                    this.readNextValue();
                    return result;
                }

                @Override
                public void remove() {
                    throw new RuntimeException("Not implemented!");
                }
            });
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
        }

        private void handleReadKeys() throws IOException {
            CloseableIterator<Long> it = this.dataInterface.keyIterator();
            while (it.hasNext()) {
                Long key = (Long)it.next();
                this.connection.writeLong(key.longValue());
            }
            it.close();
            this.connection.writeLong(0x7FFFFFFFFFFFFFFDL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReadAllValues() throws IOException {
            CloseableIterator it = this.dataInterface.iterator();
            try {
                while (it.hasNext()) {
                    KeyValue next = (KeyValue)it.next();
                    Object valueToWrite = next.getValue();
                    long key = next.getKey();
                    if (key == 0x7FFFFFFFFFFFFFFDL || key == Long.MAX_VALUE || key == 0x7FFFFFFFFFFFFFFEL) {
                        throw new RuntimeException("Unexpected key " + key + " in dataInterface " + this.dataInterface.getName());
                    }
                    this.connection.writeLong(key);
                    this.connection.writeValue(valueToWrite, this.dataInterface.getObjectClass());
                }
                this.connection.writeLong(0x7FFFFFFFFFFFFFFDL);
            }
            finally {
                IOUtils.closeQuietly(it);
            }
        }

        private void handleReadValue() throws IOException {
            long key = this.connection.readLong();
            Object value = this.dataInterface.read(key);
            this.connection.writeValue(value, this.dataInterface.getObjectClass());
        }

        private void handleMightContain() throws IOException {
            long key = this.connection.readLong();
            boolean mightContain = this.dataInterface.mightContain(key);
            this.connection.writeBoolean(mightContain);
        }

        private void handleWriteValue() throws IOException {
            long key = this.connection.readLong();
            Object value = this.connection.readValue(this.dataInterface.getObjectClass());
            this.dataInterface.write(key, value);
            this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
        }

        private Class readClass() throws IOException, ClassNotFoundException {
            String className = this.connection.readString();
            return Class.forName(className);
        }

        public void doTerminate() {
            IOUtils.closeQuietly((Closeable)this.connection);
        }
    }
}

