/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.remote;

import be.bagofwords.db.DataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.remote.RemoteDataInterfaceServer;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.ui.UI;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.WrappedSocketConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;

public class RemoteDataInterface<T>
extends DataInterface<T> {
    private static final int MAX_NUM_OF_CONNECTIONS = 200;
    private static final long MAX_WAIT = 10000L;
    private final String host;
    private final int port;
    private final List<Connection> connections;
    private final ExecutorService executorService;
    private boolean wasClosed;

    public RemoteDataInterface(String name, Class<T> objectClass, Combinator<T> combinator, String host, int port) {
        super(name, objectClass, combinator);
        this.host = host;
        this.port = port;
        this.connections = new ArrayList<Connection>();
        this.executorService = Executors.newFixedThreadPool(10);
        this.wasClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection selectConnection() throws IOException {
        Connection result = this.trySimpleSelect();
        if (result != null) {
            return result;
        }
        if (this.connections.size() < 200) {
            List<Connection> list = this.connections;
            synchronized (list) {
                if (this.connections.size() < 200) {
                    Connection newConn = new Connection(this.host, this.port);
                    this.connections.add(newConn);
                    newConn.setTaken(true);
                    return newConn;
                }
            }
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 10000L) {
            result = this.trySimpleSelect();
            if (result == null) continue;
            return result;
        }
        throw new RuntimeException("Failed to reserve a connection!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection trySimpleSelect() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                if (connection.isTaken()) continue;
                connection.setTaken(true);
                return connection;
            }
        }
        return null;
    }

    @Override
    public T read(long key) {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.READVALUE, connection);
            connection.writeLong(key);
            connection.flush();
            Object value = connection.readValue(this.getObjectClass());
            this.releaseConnection(connection);
            return (T)value;
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean mightContain(long key) {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.MIGHT_CONTAIN, connection);
            connection.writeLong(key);
            connection.flush();
            boolean result = connection.readBoolean();
            this.releaseConnection(connection);
            return result;
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public long apprSize() {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.APPROXIMATE_SIZE, connection);
            connection.flush();
            long response = connection.readLong();
            if (response == 0x7FFFFFFFFFFFFFFEL) {
                long result = connection.readLong();
                this.releaseConnection(connection);
                return result;
            }
            this.dropConnection(connection);
            throw new RuntimeException("Unexpected error while reading approximate size " + connection.readString());
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public long exactSize() {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.EXACT_SIZE, connection);
            connection.flush();
            long response = connection.readLong();
            if (response == 0x7FFFFFFFFFFFFFFEL) {
                long result = connection.readLong();
                this.releaseConnection(connection);
                return result;
            }
            this.dropConnection(connection);
            throw new RuntimeException("Unexpected error while reading approximate size " + connection.readString());
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(long key, T value) {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.WRITEVALUE, connection);
            connection.writeLong(key);
            connection.writeValue(value, this.getObjectClass());
            connection.flush();
            long response = connection.readLong();
            if (response != 0x7FFFFFFFFFFFFFFEL) {
                this.dropConnection(connection);
                throw new RuntimeException("Unexpected error while reading approximate size " + connection.readString());
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Iterator<KeyValue<T>> entries) {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(RemoteDataInterfaceServer.Action.WRITEVALUES, connection);
            while (entries.hasNext()) {
                KeyValue<T> entry = entries.next();
                connection.writeLong(entry.getKey());
                connection.writeValue(entry.getValue(), this.getObjectClass());
            }
            connection.writeLong(0x7FFFFFFFFFFFFFFDL);
            connection.flush();
            long response = connection.readLong();
            if (response != 0x7FFFFFFFFFFFFFFEL) {
                this.dropConnection(connection);
                throw new RuntimeException("Unexpected error while reading approximate size " + connection.readString());
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator(final Iterator<Long> keyIterator) {
        try {
            final Connection connection = new Connection(this.host, this.port);
            this.doAction(RemoteDataInterfaceServer.Action.READVALUES, connection);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (keyIterator.hasNext()) {
                            Long nextKey = (Long)keyIterator.next();
                            connection.writeLong(nextKey);
                        }
                        connection.writeLong(0x7FFFFFFFFFFFFFFDL);
                        connection.flush();
                    }
                    catch (Exception e) {
                        UI.writeError((String)("Received exception while sending keys for read(..), for subset " + RemoteDataInterface.this.getName() + ". Closing connection. "), (Throwable)e);
                        IOUtils.closeQuietly((Closeable)((Object)connection));
                    }
                }
            });
            return this.createNewKeyValueIterator(connection);
        }
        catch (Exception e) {
            throw new RuntimeException("Received exception while sending keys for read(..) for subset " + this.getName(), e);
        }
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        try {
            Connection connection = new Connection(this.host, this.port);
            this.doAction(RemoteDataInterfaceServer.Action.READALLVALUES, connection);
            connection.flush();
            return this.createNewKeyValueIterator(connection);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to iterate over values from " + this.host + ":" + this.port, e);
        }
    }

    private CloseableIterator<KeyValue<T>> createNewKeyValueIterator(final Connection connection) {
        return new CloseableIterator<KeyValue<T>>(){
            private KeyValue<T> next;
            {
                this.findNext();
            }

            private void findNext() {
                if (!this.wasClosed()) {
                    try {
                        long key = connection.readLong();
                        if (key == 0x7FFFFFFFFFFFFFFDL) {
                            this.next = null;
                            this.close();
                        }
                        if (key != Long.MAX_VALUE) {
                            Object value = connection.readValue(RemoteDataInterface.this.getObjectClass());
                            this.next = new KeyValue(key, value);
                        }
                        throw new RuntimeException("Unexpected response " + connection.readString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.next = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closeInt() {
                Connection connection2 = connection;
                synchronized (connection2) {
                    if (connection.isOpen()) {
                        IOUtils.closeQuietly((Closeable)((Object)connection));
                    }
                }
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public KeyValue<T> next() {
                KeyValue result = this.next;
                this.findNext();
                return result;
            }

            public void remove() {
                throw new RuntimeException("Not implemented");
            }
        };
    }

    @Override
    public CloseableIterator<Long> keyIterator() {
        try {
            final Connection connection = new Connection(this.host, this.port);
            this.doAction(RemoteDataInterfaceServer.Action.READKEYS, connection);
            connection.flush();
            return new CloseableIterator<Long>(){
                private Long next;
                {
                    this.findNext();
                }

                private void findNext() {
                    block4: {
                        try {
                            long key = connection.readLong();
                            if (key == 0x7FFFFFFFFFFFFFFDL) {
                                this.next = null;
                                this.close();
                                break block4;
                            }
                            if (key != Long.MAX_VALUE) {
                                this.next = key;
                                break block4;
                            }
                            throw new RuntimeException("Unexpected response " + connection.readString());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean hasNext() {
                    return this.next != null;
                }

                public Long next() {
                    Long result = this.next;
                    this.findNext();
                    return result;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void closeInt() {
                    Connection connection2 = connection;
                    synchronized (connection2) {
                        if (connection.isOpen()) {
                            IOUtils.closeQuietly((Closeable)((Object)connection));
                        }
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dropAllData() {
        this.doSimpleAction(RemoteDataInterfaceServer.Action.DROPALLDATA);
    }

    @Override
    public void flush() {
        this.doSimpleAction(RemoteDataInterfaceServer.Action.FLUSH);
    }

    @Override
    public void optimizeForReading() {
        this.doSimpleAction(RemoteDataInterfaceServer.Action.OPTMIZE_FOR_READING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.wasClosed()) {
            try {
                this.flush();
            }
            catch (Exception e) {
                UI.writeError((String)"Error while trying to flush data before close", (Throwable)e);
            }
            List<Connection> list = this.connections;
            synchronized (list) {
                for (Connection connection : this.connections) {
                    IOUtils.closeQuietly((Closeable)((Object)connection));
                }
                this.connections.clear();
            }
            this.executorService.shutdownNow();
            this.wasClosed = true;
        }
    }

    @Override
    public boolean wasClosed() {
        return this.wasClosed;
    }

    @Override
    public DataInterface getImplementingDataInterface() {
        return null;
    }

    private void doAction(RemoteDataInterfaceServer.Action action, Connection connection) throws IOException {
        connection.writeByte((byte)action.ordinal());
    }

    private void doSimpleAction(RemoteDataInterfaceServer.Action action) {
        Connection connection = null;
        try {
            connection = this.selectConnection();
            this.doAction(action, connection);
            connection.flush();
            long response = connection.readLong();
            if (response != 0x7FFFFFFFFFFFFFFEL) {
                this.dropConnection(connection);
                throw new RuntimeException("Unexpected response for action " + (Object)((Object)action) + " " + connection.readString());
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            this.dropConnection(connection);
            throw new RuntimeException(e);
        }
    }

    private void releaseConnection(Connection connection) {
        if (connection != null) {
            connection.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropConnection(Connection connection) {
        if (connection != null) {
            IOUtils.closeQuietly((Closeable)((Object)connection));
            List<Connection> list = this.connections;
            synchronized (list) {
                this.connections.remove((Object)connection);
            }
        }
    }

    @Override
    public void valuesChanged(long[] keys) {
        this.notifyListenersOfChangedValues(keys);
    }

    private class Connection
    extends WrappedSocketConnection {
        private boolean isTaken;

        private Connection(String host, int port) throws IOException {
            this(host, port, false);
        }

        public Connection(String host, int port, boolean useLargeOutputBuffer) throws IOException {
            super(host, port, useLargeOutputBuffer);
            this.initializeSubset();
        }

        private void initializeSubset() throws IOException {
            this.writeByte((byte)RemoteDataInterfaceServer.Action.CONNECT_TO_INTERFACE.ordinal());
            this.writeString(RemoteDataInterface.this.getName());
            this.writeString(RemoteDataInterface.this.getObjectClass().getCanonicalName());
            this.writeString(RemoteDataInterface.this.getCombinator().getClass().getCanonicalName());
            this.flush();
            long response = this.readLong();
            if (response == Long.MAX_VALUE) {
                String errorMessage = this.readString();
                throw new RuntimeException("Received unexpected message while initializing subset " + errorMessage);
            }
        }

        private boolean isTaken() {
            return this.isTaken;
        }

        private void setTaken(boolean taken) {
            this.isTaken = taken;
        }

        public void release() {
            this.isTaken = false;
        }

        public void close() throws IOException {
            RemoteDataInterface.this.doAction(RemoteDataInterfaceServer.Action.CLOSE_CONNECTION, this);
            super.close();
        }
    }
}

