/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.memory;

import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.iterator.IterableUtils;
import be.bagofwords.util.DataLock;
import be.bagofwords.util.KeyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDataInterface<T>
extends CoreDataInterface<T> {
    private Map<Long, T> values = new ConcurrentHashMap<Long, T>();
    private final DataLock lock = new DataLock();

    protected InMemoryDataInterface(String name, Class<T> objectClass, Combinator<T> combinator) {
        super(name, objectClass, combinator);
    }

    @Override
    public T read(long key) {
        return this.values.get(key);
    }

    @Override
    protected void writeInt0(long key, T value) {
        this.lock.lockWrite(key);
        this.nonSynchronizedWrite(key, value);
        this.lock.unlockWrite(key);
    }

    private void nonSynchronizedWrite(long key, T value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            T currentValue = this.values.get(key);
            if (currentValue == null) {
                this.values.put(key, value);
            } else {
                this.values.put(key, this.getCombinator().combine(currentValue, value));
            }
        }
    }

    @Override
    protected void writeInt0(Iterator<KeyValue<T>> entries) {
        this.lock.lockWriteAll();
        while (entries.hasNext()) {
            KeyValue<T> entry = entries.next();
            this.nonSynchronizedWrite(entry.getKey(), entry.getValue());
        }
        this.lock.unlockWriteAll();
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        ArrayList<Map.Entry<Long, T>> sortedValues = new ArrayList<Map.Entry<Long, T>>(this.values.entrySet());
        Collections.sort(sortedValues, new Comparator<Map.Entry<Long, T>>(){

            @Override
            public int compare(Map.Entry<Long, T> o1, Map.Entry<Long, T> o2) {
                return Long.compare(o1.getKey(), o2.getKey());
            }
        });
        final Iterator valuesIt = sortedValues.iterator();
        return new CloseableIterator<KeyValue<T>>(){

            public boolean hasNext() {
                return valuesIt.hasNext();
            }

            public KeyValue<T> next() {
                Map.Entry next = (Map.Entry)valuesIt.next();
                return new KeyValue(((Long)next.getKey()).longValue(), next.getValue());
            }

            public void remove() {
                valuesIt.remove();
            }

            public void closeInt() {
            }
        };
    }

    @Override
    public void dropAllData() {
        this.lock.lockWriteAll();
        this.values.clear();
        this.lock.unlockWriteAll();
    }

    @Override
    public void flush() {
        this.lock.lockWriteAll();
        this.lock.unlockWriteAll();
    }

    @Override
    protected void doClose() {
        this.lock.lockWriteAll();
        this.values = null;
        this.lock.unlockWriteAll();
    }

    @Override
    public long apprSize() {
        return this.values.size();
    }

    @Override
    public CloseableIterator<Long> keyIterator() {
        this.lock.lockReadAll();
        ArrayList<Long> sortedKeys = new ArrayList<Long>(this.values.keySet());
        this.lock.unlockReadAll();
        Collections.sort(sortedKeys);
        return IterableUtils.iterator(sortedKeys.iterator());
    }

    @Override
    public void optimizeForReading() {
    }

    @Override
    public long exactSize() {
        this.lock.lockReadAll();
        long result = this.values.size();
        this.lock.unlockReadAll();
        return result;
    }

    @Override
    public boolean mightContain(long key) {
        this.lock.lockRead(key);
        boolean result = this.values.containsKey(key);
        this.lock.unlockRead(key);
        return result;
    }
}

