/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.leveldb;

import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.DataLock;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.SerializationUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.JniDB;
import org.fusesource.leveldbjni.internal.JniKeyDBIterator;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;

public class LevelDBDataInterface<T>
extends CoreDataInterface<T> {
    private DB db;
    private File databaseDir;
    private DataLock dataLock;

    public LevelDBDataInterface(String directory, String name, Class<T> objectClass, Combinator<T> combinator) {
        super(name, objectClass, combinator);
        try {
            this.databaseDir = new File(directory + File.separator + name);
            if (!this.databaseDir.exists()) {
                this.databaseDir.mkdirs();
            }
            this.db = JniDBFactory.factory.open(this.databaseDir, this.createOptions());
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
        this.dataLock = new DataLock();
    }

    private Options createOptions() {
        Options options = new Options();
        options.createIfMissing(true);
        return options;
    }

    @Override
    public void optimizeForReading() {
        this.db.compactRange(null, null);
    }

    @Override
    public T read(long key) {
        return (T)SerializationUtils.bytesToObject((byte[])this.db.get(SerializationUtils.longToBytes((long)key)), this.getObjectClass());
    }

    @Override
    protected void writeInt0(long key, T value) {
        this.dataLock.lockWrite(key);
        if (value == null) {
            this.db.delete(SerializationUtils.longToBytes((long)key));
        } else {
            byte[] keyInBytes = SerializationUtils.longToBytes((long)key);
            byte[] currentValueInBytes = this.db.get(keyInBytes);
            Object valueToWrite = currentValueInBytes == null ? value : this.getCombinator().combine(SerializationUtils.bytesToObject((byte[])currentValueInBytes, this.getObjectClass()), value);
            this.db.put(keyInBytes, SerializationUtils.objectToBytes(valueToWrite, this.getObjectClass()));
        }
        this.dataLock.unlockWrite(key);
    }

    @Override
    public CloseableIterator<Long> keyIterator() {
        final JniKeyDBIterator iterator = ((JniDB)this.db).keyIterator(new ReadOptions());
        iterator.seekToFirst();
        return new CloseableIterator<Long>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Long next() {
                byte[] entry = iterator.next();
                return SerializationUtils.bytesToLong((byte[])entry);
            }

            public void remove() {
                throw new RuntimeException("Not implemented");
            }

            public void closeInt() {
                iterator.close();
            }
        };
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        final DBIterator iterator = this.db.iterator();
        iterator.seekToFirst();
        return new CloseableIterator<KeyValue<T>>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<T> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return new KeyValue(SerializationUtils.bytesToLong((byte[])((byte[])entry.getKey())), SerializationUtils.bytesToObject((byte[])((byte[])entry.getValue()), LevelDBDataInterface.this.getObjectClass()));
            }

            public void remove() {
                throw new RuntimeException("Not implemented");
            }

            public void closeInt() {
            }
        };
    }

    @Override
    public void dropAllData() {
        this.dataLock.lockWriteAll();
        Options options = new Options();
        try {
            this.db.close();
            JniDBFactory.factory.destroy(this.databaseDir, options);
            options = new Options();
            options.createIfMissing(true);
            this.db = JniDBFactory.factory.open(this.databaseDir, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dataLock.unlockWriteAll();
    }

    @Override
    public void flush() {
    }

    @Override
    protected void doClose() {
        try {
            this.db.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.db = null;
    }

    @Override
    public long apprSize() {
        return this.exactSize();
    }

    @Override
    public void writeInt0(Iterator<KeyValue<T>> entries) {
        WriteBatch writeBatch = this.db.createWriteBatch();
        while (entries.hasNext()) {
            KeyValue<T> entry = entries.next();
            long key = entry.getKey();
            byte[] keyInBytes = SerializationUtils.longToBytes((long)key);
            this.dataLock.lockWrite(key);
            byte[] currentValueInBytes = this.db.get(keyInBytes);
            Object valueToWrite = entry.getValue() == null ? null : (currentValueInBytes == null ? entry.getValue() : this.getCombinator().combine(SerializationUtils.bytesToObject((byte[])currentValueInBytes, this.getObjectClass()), entry.getValue()));
            if (valueToWrite == null) {
                writeBatch.delete(keyInBytes);
            } else {
                writeBatch.put(keyInBytes, SerializationUtils.objectToBytes((Object)valueToWrite, this.getObjectClass()));
            }
            this.dataLock.unlockWrite(key);
        }
        this.db.write(writeBatch);
        try {
            writeBatch.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

