/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.filedb;

import be.bagofwords.util.Pair;
import java.util.Collections;
import java.util.List;

class FileInfo
implements Comparable {
    private final long firstKey;
    private int size;
    private byte[] cachedFileContents;
    private List<Pair<Long, Integer>> fileLocations;

    public FileInfo(long firstKey, int size) {
        this.firstKey = firstKey;
        this.size = size;
        if (size == 0) {
            this.fileLocations = Collections.emptyList();
        }
    }

    public long getFirstKey() {
        return this.firstKey;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isDirty() {
        return this.fileLocations == null;
    }

    public void fileIsCleaned(List<Pair<Long, Integer>> fileLocations) {
        this.fileLocations = fileLocations;
    }

    public int compareTo(Object o) {
        if (o instanceof FileInfo) {
            return Long.compare(this.getFirstKey(), ((FileInfo)o).getFirstKey());
        }
        if (o instanceof Long) {
            return Long.compare(this.getFirstKey(), (Long)o);
        }
        throw new RuntimeException("Can not compare FileInfo with " + o);
    }

    public String toString() {
        return super.toString() + " " + this.getFirstKey() + " " + this.getSize() + " " + this.isDirty();
    }

    public void increaseSize(long diff, boolean cleanWrite) {
        this.size = (int)((long)this.size + diff);
        if (!cleanWrite) {
            this.fileLocations = null;
        }
    }

    public List<Pair<Long, Integer>> getFileLocations() {
        return this.fileLocations;
    }

    public long discardFileContents() {
        int bytesReleased = 0;
        if (this.cachedFileContents != null) {
            bytesReleased = this.cachedFileContents.length;
            this.cachedFileContents = null;
        }
        return bytesReleased;
    }

    public byte[] getCachedFileContents() {
        return this.cachedFileContents;
    }

    public void setCachedFileContents(byte[] cachedFileContents) {
        this.cachedFileContents = cachedFileContents;
    }
}

