/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.filedb;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.application.environment.FileCountDBEnvironmentProperties;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.filedb.FileDataInterface;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class FileDataInterfaceFactory
extends DataInterfaceFactory {
    private final MemoryManager memoryManager;
    private final String directory;
    private final OccasionalActionsThread occasionalActionsThread;

    @Autowired
    public FileDataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, FileCountDBEnvironmentProperties fileCountDBEnvironmentProperties) {
        this(cachesManager, memoryManager, fileCountDBEnvironmentProperties.getDataDirectory() + "server/");
    }

    public FileDataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, String directory) {
        super(cachesManager, memoryManager);
        this.memoryManager = memoryManager;
        this.directory = directory;
        this.occasionalActionsThread = new OccasionalActionsThread();
        this.occasionalActionsThread.start();
    }

    @Override
    protected <T> DataInterface<T> createBaseDataInterface(String nameOfSubset, Class<T> objectClass, Combinator<T> combinator) {
        FileDataInterface<T> result = new FileDataInterface<T>(this.memoryManager, combinator, objectClass, this.directory, nameOfSubset);
        this.memoryManager.registerMemoryGobbler(result);
        this.occasionalActionsThread.addInterface(result);
        return result;
    }

    @Override
    public void terminate() {
        this.occasionalActionsThread.terminateAndWaitForFinish();
        super.terminate();
    }

    private class OccasionalActionsThread
    extends SafeThread {
        private final List<FileDataInterface> interfaces;

        public OccasionalActionsThread() {
            super("OccastionalActionsThread", true);
            this.interfaces = new ArrayList<FileDataInterface>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInterface(FileDataInterface newInterface) {
            List<FileDataInterface> list = this.interfaces;
            synchronized (list) {
                this.interfaces.add(newInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInt() throws Exception {
            while (!this.isTerminateRequested()) {
                List<FileDataInterface> list = this.interfaces;
                synchronized (list) {
                    for (int i = 0; i < this.interfaces.size(); ++i) {
                        this.interfaces.get(i).doOccasionalAction();
                    }
                }
                Utils.threadSleep((long)1000L);
            }
        }
    }
}

