/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.filedb;

import be.bagofwords.application.memory.MemoryGobbler;
import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.application.memory.MemoryStatus;
import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.filedb.FileBucket;
import be.bagofwords.db.filedb.FileInfo;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.iterator.IterableUtils;
import be.bagofwords.iterator.SimpleIterator;
import be.bagofwords.ui.UI;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.MappedLists;
import be.bagofwords.util.Pair;
import be.bagofwords.util.SerializationUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class FileDataInterface<T>
extends CoreDataInterface<T>
implements MemoryGobbler {
    private static final long MAX_FILE_SIZE_WRITE = 0xA00000L;
    private static final long MAX_FILE_SIZE_READ = 0x100000L;
    private static final long BITS_TO_DISCARD_FOR_FILE_BUCKETS = 58L;
    private static final int BATCH_SIZE = 1000000;
    private static final String CLEAN_FILES_FILE = "CLEAN_FILES";
    private static final String LOCK_FILE = "LOCK";
    private static final long LONG_NULL = Long.MAX_VALUE;
    private static final int INT_NULL = Integer.MAX_VALUE;
    private static final double DOUBLE_NULL = Double.MAX_VALUE;
    private static final float FLOAT_NULL = Float.MAX_VALUE;
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private final String sizeOfCachedFileContentsLock = new String("LOCK");
    private final int sizeOfValues;
    private final long randomId;
    private File directory;
    private FileBucket[] fileBuckets;
    private MemoryManager memoryManager;
    private final long maxSizeOfCachedFileContents = Runtime.getRuntime().maxMemory() / 3L;
    private long timeOfLastWrite;
    private long timeOfLastRead;
    private long timeOfLastWriteOfCleanFilesList;
    private long currentSizeOfCachedFileContents;

    public FileDataInterface(MemoryManager memoryManager, Combinator<T> combinator, Class<T> objectClass, String directory, String nameOfSubset) {
        super(nameOfSubset, objectClass, combinator);
        this.directory = new File(directory, nameOfSubset);
        this.sizeOfValues = SerializationUtils.getWidth(objectClass);
        this.randomId = new Random().nextLong();
        this.memoryManager = memoryManager;
        this.initializeFileBuckets();
        this.checkDataDir();
        this.writeLockFile(this.randomId);
        this.timeOfLastRead = 0L;
        this.timeOfLastWrite = this.timeOfLastWriteOfCleanFilesList = System.currentTimeMillis();
        this.currentSizeOfCachedFileContents = 0L;
    }

    private void writeLockFile(long id) {
        File lockFile = new File(this.directory, LOCK_FILE);
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(lockFile));
            dos.writeLong(id);
            IOUtils.closeQuietly((OutputStream)dos);
        }
        catch (Exception exp) {
            throw new RuntimeException("Unexpected exception while trying to write lock file to " + lockFile.getAbsolutePath(), exp);
        }
    }

    @Override
    public T read(long key) {
        FileBucket bucket = this.getBucket(key);
        bucket.lockRead();
        FileInfo file = bucket.getFile(key);
        try {
            while (file.isDirty()) {
                bucket.unlockRead();
                bucket.lockWrite();
                file = bucket.getFile(key);
                this.rewriteFile(bucket, file, false, 0x100000L);
                bucket.unlockWrite();
                bucket.lockRead();
                file = bucket.getFile(key);
            }
            T result = this.readSingleValue(key, file);
            this.timeOfLastRead = System.currentTimeMillis();
            T t = result;
            return t;
        }
        catch (Exception exp) {
            throw new RuntimeException("Error in file " + this.toFile(file).getAbsolutePath(), exp);
        }
        finally {
            bucket.unlockRead();
        }
    }

    @Override
    public void writeInt0(long key, T value) {
        FileBucket bucket = this.getBucket(key);
        bucket.lockWrite();
        int fileInd = bucket.getFileInd(key);
        FileInfo file = bucket.getFiles().get(fileInd);
        try {
            DataOutputStream dos = this.getOutputStream(file, true);
            long extraSize = this.writeValue(dos, key, value);
            file.increaseSize(extraSize, false);
            dos.close();
            this.rewriteFileAfterWriteIfNecessary(bucket, file);
            this.timeOfLastWrite = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write value with key " + key + " to file " + this.toFile(file).getAbsolutePath(), e);
        }
        finally {
            bucket.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInt0(Iterator<KeyValue<T>> entries) {
        while (entries.hasNext()) {
            MappedLists entriesToFileBuckets = new MappedLists();
            for (int numRead = 0; numRead < 1000000 && entries.hasNext(); ++numRead) {
                KeyValue<T> curr = entries.next();
                FileBucket fileBucket = this.getBucket(curr.getKey());
                entriesToFileBuckets.get((Object)fileBucket).add(curr);
            }
            for (FileBucket bucket : entriesToFileBuckets.keySet()) {
                List values = entriesToFileBuckets.get((Object)bucket);
                bucket.lockWrite();
                try {
                    MappedLists entriesToFiles = new MappedLists();
                    for (KeyValue value : values) {
                        FileInfo file = bucket.getFile(value.getKey());
                        entriesToFiles.get((Object)file).add(value);
                    }
                    for (FileInfo file : entriesToFiles.keySet()) {
                        try {
                            List valuesForFile = entriesToFiles.get((Object)file);
                            DataOutputStream dos = this.getOutputStream(file, true);
                            for (KeyValue value : valuesForFile) {
                                long extraSize = this.writeValue(dos, value.getKey(), value.getValue());
                                file.increaseSize(extraSize, false);
                            }
                            dos.close();
                            this.rewriteFileAfterWriteIfNecessary(bucket, file);
                        }
                        catch (Exception exp) {
                            throw new RuntimeException("Failed to write multiple values to file " + this.toFile(file).getAbsolutePath(), exp);
                        }
                    }
                }
                finally {
                    bucket.unlockWrite();
                }
            }
        }
        this.timeOfLastWrite = System.currentTimeMillis();
    }

    private void rewriteFileAfterWriteIfNecessary(FileBucket bucket, FileInfo file) {
        long targetSize;
        boolean needsRewrite;
        if (this.shouldFilesBeOptimizedForReads()) {
            needsRewrite = file.isDirty();
            targetSize = 0x100000L;
        } else {
            needsRewrite = (long)file.getSize() > 0xA00000L;
            targetSize = 0x280000L;
        }
        if (needsRewrite) {
            this.rewriteFile(bucket, file, true, targetSize);
        }
    }

    private boolean shouldFilesBeOptimizedForReads() {
        return System.currentTimeMillis() - this.timeOfLastRead < 1000L;
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator(final Iterator<Long> keyIterator) {
        this.timeOfLastRead = System.currentTimeMillis();
        return IterableUtils.iterator((SimpleIterator)new SimpleIterator<KeyValue<T>>(){
            private FileInfo currentFile;
            private Map<Long, T> valuesInFile;

            public KeyValue<T> next() throws Exception {
                while (keyIterator.hasNext()) {
                    Object value;
                    long key = (Long)keyIterator.next();
                    FileBucket currentBucket = FileDataInterface.this.getBucket(key);
                    FileInfo file = currentBucket.getFile(key);
                    if (file != this.currentFile) {
                        this.currentFile = file;
                        currentBucket.lockRead();
                        this.valuesInFile = FileDataInterface.this.readMap(currentBucket, file);
                        currentBucket.unlockRead();
                    }
                    if ((value = this.valuesInFile.get(key)) == null) continue;
                    return new KeyValue(key, value);
                }
                return null;
            }
        });
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        this.timeOfLastRead = System.currentTimeMillis();
        final FileIterator fileIterator = this.createFileIterator();
        return IterableUtils.iterator((SimpleIterator)new SimpleIterator<KeyValue<T>>(){
            private Iterator<Pair<Long, T>> valuesInFileIt;

            public KeyValue<T> next() throws Exception {
                Object next;
                while (this.valuesInFileIt == null || !this.valuesInFileIt.hasNext()) {
                    next = fileIterator.lockCurrentBucketAndGetNextFile();
                    if (next != null) {
                        FileBucket bucket = (FileBucket)next.getFirst();
                        FileInfo file = (FileInfo)next.getSecond();
                        List sortedEntries = FileDataInterface.this.readValuesWithCheck(bucket, file);
                        bucket.unlockRead();
                        this.valuesInFileIt = sortedEntries.iterator();
                        continue;
                    }
                    this.valuesInFileIt = null;
                    break;
                }
                if (this.valuesInFileIt != null && this.valuesInFileIt.hasNext()) {
                    next = this.valuesInFileIt.next();
                    return new KeyValue(((Long)next.getFirst()).longValue(), next.getSecond());
                }
                return null;
            }
        });
    }

    @Override
    public CloseableIterator<Long> keyIterator() {
        this.timeOfLastRead = System.currentTimeMillis();
        final FileIterator fileIterator = this.createFileIterator();
        return IterableUtils.iterator((SimpleIterator)new SimpleIterator<Long>(){
            private Iterator<Long> keysInFileIt;

            public Long next() throws Exception {
                while (this.keysInFileIt == null || !this.keysInFileIt.hasNext()) {
                    Pair<FileBucket, FileInfo> next = fileIterator.lockCurrentBucketAndGetNextFile();
                    if (next != null) {
                        FileBucket bucket = (FileBucket)next.getFirst();
                        FileInfo file = (FileInfo)next.getSecond();
                        List sortedKeys = FileDataInterface.this.readKeys(bucket, file);
                        bucket.unlockRead();
                        this.keysInFileIt = sortedKeys.iterator();
                        continue;
                    }
                    this.keysInFileIt = null;
                    break;
                }
                if (this.keysInFileIt != null && this.keysInFileIt.hasNext()) {
                    return this.keysInFileIt.next();
                }
                return null;
            }
        });
    }

    public synchronized void freeMemory() {
        if (!this.wasClosed()) {
            for (FileBucket bucket : this.fileBuckets) {
                if (!bucket.tryLockRead()) continue;
                for (FileInfo fileInfo : bucket.getFiles()) {
                    long bytesReleased = fileInfo.discardFileContents();
                    this.updateSizeOfCachedFileContents(-bytesReleased);
                }
                bucket.unlockRead();
            }
        }
    }

    public String getMemoryUsage() {
        long totalUsed = 0L;
        for (FileBucket bucket : this.fileBuckets) {
            bucket.lockRead();
            for (FileInfo fileInfo : bucket.getFiles()) {
                byte[] cachedContents = fileInfo.getCachedFileContents();
                if (cachedContents == null) continue;
                totalUsed += (long)cachedContents.length;
            }
            bucket.unlockRead();
        }
        return "cached file contents " + totalUsed;
    }

    @Override
    public long apprSize() {
        int numOfFilesToSample = 100;
        long numOfObjects = 0L;
        long sizeOfSampledFiles = 0L;
        int numOfSampledFiles = 0;
        long sizeOfAllFiles = 0L;
        try {
            FileIterator fileIt = this.createFileIterator();
            Pair<FileBucket, FileInfo> next = fileIt.lockCurrentBucketAndGetNextFile();
            while (next != null) {
                FileBucket bucket = (FileBucket)next.getFirst();
                FileInfo file = (FileInfo)next.getSecond();
                long fileSize = file.getSize();
                if (numOfSampledFiles < numOfFilesToSample) {
                    List<Long> keys = this.readKeys(bucket, file);
                    numOfObjects += (long)keys.size();
                    sizeOfSampledFiles += fileSize;
                    if (fileSize == 0L && !keys.isEmpty()) {
                        UI.writeError((String)("Something is wrong with file " + file.getFirstKey()));
                    }
                    ++numOfSampledFiles;
                }
                bucket.unlockRead();
                sizeOfAllFiles += fileSize;
                next = fileIt.lockCurrentBucketAndGetNextFile();
            }
            if (numOfObjects == 0L) {
                return 0L;
            }
            return sizeOfAllFiles * numOfObjects / sizeOfSampledFiles;
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void optimizeForReading() {
        this.timeOfLastRead = System.currentTimeMillis();
        for (FileBucket fileBucket : this.fileBuckets) {
            fileBucket.lockWrite();
            for (int fileInd = 0; fileInd < fileBucket.getFiles().size(); ++fileInd) {
                FileInfo file = fileBucket.getFiles().get(fileInd);
                if (!file.isDirty()) continue;
                this.rewriteFile(fileBucket, file, false, 0x100000L);
            }
            fileBucket.unlockWrite();
        }
    }

    @Override
    protected synchronized void doClose() {
        try {
            this.writeCleanFilesListIfNecessary();
        }
        finally {
            this.fileBuckets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSizeOfCachedFileContents(long byteDiff) {
        String string = this.sizeOfCachedFileContentsLock;
        synchronized (string) {
            this.currentSizeOfCachedFileContents += byteDiff;
        }
    }

    @Override
    public void dropAllData() {
        try {
            this.writeLockAllBuckets();
            for (FileBucket bucket : this.fileBuckets) {
                for (FileInfo file : bucket.getFiles()) {
                    this.deleteFile(file);
                }
                bucket.getFiles().clear();
            }
            this.writeCleanFilesListNonSynchronized();
            this.initializeFiles();
            this.writeUnlockAllBuckets();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLockAllBuckets() {
        for (FileBucket fileBucket : this.fileBuckets) {
            fileBucket.lockWrite();
        }
    }

    private void writeUnlockAllBuckets() {
        for (FileBucket fileBucket : this.fileBuckets) {
            fileBucket.unlockWrite();
        }
    }

    private void readLockAllBuckets() {
        for (FileBucket fileBucket : this.fileBuckets) {
            fileBucket.lockRead();
        }
    }

    private void readUnlockAllBuckets() {
        for (FileBucket fileBucket : this.fileBuckets) {
            fileBucket.unlockRead();
        }
    }

    private List<Pair<Long, T>> rewriteFile(FileBucket bucket, FileInfo file, boolean inWritePhase, long maxFileSize) {
        try {
            int fileInd = bucket.getFiles().indexOf(file);
            List<Pair<Long, T>> values = this.readValues(file);
            int filesMergedWithThisFile = inWritePhase ? 0 : this.mergeFileIfTooSmall(bucket, fileInd, file, maxFileSize, values);
            DataOutputStream dos = this.getOutputStream(file, false);
            file.setSize(0);
            ArrayList<Object> fileLocations = new ArrayList<Pair<Long, Integer>>();
            for (Pair<Long, T> entry : values) {
                long key = (Long)entry.getFirst();
                Object value = entry.getSecond();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream tmpOutputStream = new DataOutputStream(bos);
                this.writeValue(tmpOutputStream, key, value);
                byte[] dataToWrite = bos.toByteArray();
                if (file.getSize() > 0 && (long)(file.getSize() + dataToWrite.length) > maxFileSize) {
                    if (filesMergedWithThisFile > 0) {
                        throw new RuntimeException("Something went wrong! Merged file and then created new file?");
                    }
                    dos.close();
                    file.fileIsCleaned(this.sample(fileLocations, 100));
                    fileLocations = new ArrayList();
                    file = new FileInfo(key, 0);
                    bucket.getFiles().add(fileInd + 1, file);
                    ++fileInd;
                    dos = this.getOutputStream(file, false);
                }
                fileLocations.add((Pair<Long, Integer>)new Pair((Object)key, (Object)file.getSize()));
                dos.write(dataToWrite);
                file.increaseSize(dataToWrite.length, true);
            }
            file.fileIsCleaned(this.sample(fileLocations, 100));
            dos.close();
            return values;
        }
        catch (Exception exp) {
            try {
                this.close();
            }
            catch (Exception exp2) {
                // empty catch block
            }
            throw new RuntimeException("Unexpected exception while rewriting file " + this.toFile(file).getAbsolutePath() + ". Closed this data interface", exp);
        }
    }

    private int mergeFileIfTooSmall(FileBucket bucket, int currentFileInd, FileInfo file, long maxFileSize, List<Pair<Long, T>> values) {
        int nextFileInd = currentFileInd + 1;
        long combinedSize = file.getSize();
        while (nextFileInd < bucket.getFiles().size() && combinedSize + (long)bucket.getFiles().get(nextFileInd).getSize() < maxFileSize) {
            FileInfo nextFile = bucket.getFiles().remove(nextFileInd);
            values.addAll(this.readValues(nextFile));
            combinedSize += (long)nextFile.getSize();
            this.deleteFile(nextFile);
        }
        return nextFileInd - currentFileInd - 1;
    }

    private long writeValue(DataOutputStream dos, long key, T value) throws IOException {
        dos.writeLong(key);
        byte[] objectAsBytes = SerializationUtils.objectToBytesCheckForNull(value, this.getObjectClass());
        if (this.sizeOfValues == -1) {
            dos.writeInt(objectAsBytes.length);
            dos.write(objectAsBytes);
            return 12 + objectAsBytes.length;
        }
        dos.write(objectAsBytes);
        return 8 + this.sizeOfValues;
    }

    private ReadValue<T> readValue(byte[] buffer, int position) throws IOException {
        int lenghtOfLengthValue;
        int lengthOfObject;
        if (this.sizeOfValues == -1) {
            lengthOfObject = SerializationUtils.bytesToInt((byte[])buffer, (int)position);
            lenghtOfLengthValue = 4;
        } else {
            lengthOfObject = this.sizeOfValues;
            lenghtOfLengthValue = 0;
        }
        Object value = SerializationUtils.bytesToObjectCheckForNull((byte[])buffer, (int)(position + lenghtOfLengthValue), (int)lengthOfObject, this.getObjectClass());
        return new ReadValue(lengthOfObject + lenghtOfLengthValue, value);
    }

    private void initializeFileBuckets() {
        this.fileBuckets = new FileBucket[64];
        long start = -32L;
        long end = 31L;
        int ind = 0;
        for (long val = start; val <= end; ++val) {
            long lastKey = (val + 1L << 58) - 1L;
            long firstKey = val << 58;
            if (lastKey < firstKey) {
                lastKey = Long.MAX_VALUE;
            }
            this.fileBuckets[ind++] = new FileBucket(firstKey, lastKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataDir() {
        Class<FileDataInterface> clazz = FileDataInterface.class;
        synchronized (FileDataInterface.class) {
            boolean success;
            if (!this.directory.exists() && !(success = this.directory.mkdirs())) {
                throw new RuntimeException("Failed to create directory " + this.directory.getAbsolutePath());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.directory.isFile()) {
                throw new IllegalArgumentException("File should be directory but is file! " + this.directory.getAbsolutePath());
            }
            try {
                this.initializeFiles();
            }
            catch (IOException exp) {
                throw new RuntimeException(exp);
            }
            return;
        }
    }

    private void initializeFiles() throws IOException {
        Map<Long, List<Pair<Long, Integer>>> cleanFileInfo = this.readCleanFileInfo();
        for (String file : this.directory.list()) {
            if (!file.matches("-?[0-9]+")) continue;
            long key = Long.parseLong(file);
            FileBucket bucket = this.getBucket(key);
            int size = this.sizeToInteger(new File(this.directory, file).length());
            FileInfo fileInfo = new FileInfo(key, size);
            boolean isClean = cleanFileInfo.containsKey(key);
            if (isClean) {
                fileInfo.fileIsCleaned(cleanFileInfo.get(key));
            }
            bucket.getFiles().add(fileInfo);
        }
        for (FileBucket bucket : this.fileBuckets) {
            if (bucket.getFiles().isEmpty()) {
                FileInfo first = new FileInfo(bucket.getFirstKey(), 0);
                try {
                    boolean success = this.toFile(first).createNewFile();
                    if (!success) {
                        throw new RuntimeException("Failed to create new file " + first + " at " + this.toFile(first).getAbsolutePath());
                    }
                    bucket.getFiles().add(first);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Collections.sort(bucket.getFiles());
            if (bucket.getFirstKey() == bucket.getFiles().get(0).getFirstKey()) continue;
            throw new RuntimeException("Missing file in " + this.getName() + " ? Expected file " + new File(this.directory, Long.toString(bucket.getFirstKey())).getAbsolutePath());
        }
    }

    private Map<Long, List<Pair<Long, Integer>>> readCleanFileInfo() {
        HashMap<Long, List<Pair<Long, Integer>>> result = new HashMap<Long, List<Pair<Long, Integer>>>();
        File cleanFilesFile = new File(this.directory, CLEAN_FILES_FILE);
        if (cleanFilesFile.exists()) {
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(cleanFilesFile));
                boolean finished = false;
                while (!finished) {
                    try {
                        long startKey = dis.readLong();
                        int numOfFileLocations = dis.readInt();
                        ArrayList<Pair> fileLocations = new ArrayList<Pair>();
                        for (int i = 0; i < numOfFileLocations; ++i) {
                            fileLocations.add(new Pair((Object)dis.readLong(), (Object)dis.readInt()));
                        }
                        result.put(startKey, fileLocations);
                    }
                    catch (EOFException exp) {
                        finished = true;
                    }
                }
            }
            catch (Exception exp) {
                UI.writeError((String)("Received exception while reading " + cleanFilesFile.getAbsolutePath()), (Throwable)exp);
            }
        }
        return result;
    }

    public synchronized void writeCleanFilesListIfNecessary() {
        long currentTimeOfLastWrite = this.timeOfLastWrite;
        if (currentTimeOfLastWrite > this.timeOfLastWriteOfCleanFilesList) {
            this.readLockAllBuckets();
            this.writeCleanFilesListNonSynchronized();
            this.timeOfLastWriteOfCleanFilesList = currentTimeOfLastWrite;
            this.readUnlockAllBuckets();
        }
    }

    private void writeCleanFilesListNonSynchronized() {
        File outputFile = new File(this.directory, CLEAN_FILES_FILE);
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(outputFile));
            for (FileBucket bucket : this.fileBuckets) {
                for (FileInfo fileInfo : bucket.getFiles()) {
                    if (fileInfo.isDirty() || fileInfo.getSize() <= 0) continue;
                    dos.writeLong(fileInfo.getFirstKey());
                    dos.writeInt(fileInfo.getFileLocations().size());
                    for (Pair<Long, Integer> location : fileInfo.getFileLocations()) {
                        dos.writeLong((Long)location.getFirst());
                        dos.writeInt((Integer)location.getSecond());
                    }
                }
            }
            dos.close();
        }
        catch (Exception exp) {
            throw new RuntimeException("Received exception while writing list of clean files to " + outputFile.getAbsolutePath(), exp);
        }
    }

    private FileBucket getBucket(long key) {
        int ind = (int)((key >> 58) + (long)(this.fileBuckets.length / 2));
        return this.fileBuckets[ind];
    }

    private T readSingleValue(long keyToRead, FileInfo file) throws IOException {
        int pos;
        int n = pos = file.getFileLocations() != null ? Collections.binarySearch(file.getFileLocations(), keyToRead) : -1;
        if (pos == -1) {
            return null;
        }
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (pos == file.getFileLocations().size() || (Long)file.getFileLocations().get(pos).getFirst() > keyToRead) {
            --pos;
        }
        int startPos = (Integer)file.getFileLocations().get(pos).getSecond();
        int endPos = pos + 1 < file.getFileLocations().size() ? ((Integer)file.getFileLocations().get(pos + 1).getSecond()).intValue() : file.getSize();
        ReadBuffer readBuffer = this.getReadBuffer(file, startPos, endPos);
        endPos -= readBuffer.getOffset();
        byte firstByteOfKeyToRead = (byte)(keyToRead >> 56);
        byte[] buffer = readBuffer.getBuffer();
        int position = startPos -= readBuffer.getOffset();
        while (position < endPos) {
            byte currentByte = buffer[position];
            if (currentByte == firstByteOfKeyToRead) {
                long key = SerializationUtils.bytesToLong((byte[])buffer, (int)position);
                position += 8;
                if (key == keyToRead) {
                    ReadValue<T> readValue = this.readValue(buffer, position);
                    return readValue.getValue();
                }
                if (key > keyToRead) {
                    return null;
                }
                position += this.skipValue(buffer, position);
                continue;
            }
            if (currentByte > firstByteOfKeyToRead) {
                return null;
            }
            if (currentByte >= firstByteOfKeyToRead) continue;
            position += 8;
            position += this.skipValue(buffer, position);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadBuffer getReadBuffer(FileInfo file, int requestedStartPos, int requestedEndPos) throws IOException {
        byte[] fileContents = file.getCachedFileContents();
        if (fileContents == null) {
            if (this.memoryManager.getMemoryStatus() == MemoryStatus.FREE && this.currentSizeOfCachedFileContents < this.maxSizeOfCachedFileContents) {
                FileInfo fileInfo = file;
                synchronized (fileInfo) {
                    fileContents = file.getCachedFileContents();
                    if (fileContents == null) {
                        fileContents = new byte[file.getSize()];
                        FileInputStream fis = new FileInputStream(this.toFile(file));
                        int bytesRead = fis.read(fileContents);
                        if (bytesRead != file.getSize()) {
                            throw new RuntimeException("Read " + bytesRead + " bytes, while we expected " + file.getSize() + " bytes in file " + this.toFile(file).getAbsolutePath() + " which currently has size " + this.toFile(file).length());
                        }
                        this.updateSizeOfCachedFileContents(fileContents.length);
                        IOUtils.closeQuietly((InputStream)fis);
                    }
                    file.setCachedFileContents(fileContents);
                }
                return new ReadBuffer(fileContents, 0);
            }
            FileInputStream fis = new FileInputStream(this.toFile(file));
            long bytesSkipped = fis.skip(requestedStartPos);
            if (bytesSkipped != (long)requestedStartPos) {
                throw new RuntimeException("Skipped " + bytesSkipped + " bytes, while we expected to skip " + requestedStartPos + " bytes in file " + this.toFile(file).getAbsolutePath() + " which currently has size " + this.toFile(file).length());
            }
            byte[] buffer = new byte[requestedEndPos - requestedStartPos];
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new RuntimeException("Read " + bytesRead + " bytes, while we expected " + file.getSize() + " bytes in file " + this.toFile(file).getAbsolutePath() + " which currently has size " + this.toFile(file).length());
            }
            IOUtils.closeQuietly((InputStream)fis);
            return new ReadBuffer(buffer, requestedStartPos);
        }
        if (fileContents.length != file.getSize()) {
            throw new RuntimeException("Buffer and file size don't match!");
        }
        return new ReadBuffer(fileContents, 0);
    }

    private int skipValue(byte[] buffer, int position) throws IOException {
        Class objectClass = this.getObjectClass();
        if (objectClass == Long.class || objectClass == Double.class) {
            return 8;
        }
        if (objectClass == Integer.class || objectClass == Float.class) {
            return 4;
        }
        int length = SerializationUtils.bytesToInt((byte[])buffer, (int)position);
        return 4 + length;
    }

    private DataOutputStream getOutputStream(FileInfo fileInfo, boolean append) throws FileNotFoundException {
        long bytesReleased = fileInfo.discardFileContents();
        this.updateSizeOfCachedFileContents(-bytesReleased);
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.toFile(fileInfo), append)));
    }

    private File toFile(FileInfo fileInfo) {
        if (this.directory == null) {
            throw new RuntimeException("Directory is null, probably the data interface was closed already!");
        }
        return new File(this.directory, Long.toString(fileInfo.getFirstKey()));
    }

    private Map<Long, T> readMap(FileBucket bucket, FileInfo file) {
        List<Pair<Long, T>> values = this.readValuesWithCheck(bucket, file);
        HashMap<Object, Object> result = new HashMap<Object, Object>(values.size());
        for (Pair<Long, T> value : values) {
            result.put(value.getFirst(), value.getSecond());
        }
        return result;
    }

    private List<Pair<Long, T>> readValuesWithCheck(FileBucket bucket, FileInfo file) {
        if (file.isDirty()) {
            bucket.unlockRead();
            bucket.lockWrite();
            List<Pair<Long, T>> result = this.rewriteFile(bucket, file, false, 0x100000L);
            bucket.unlockWrite();
            bucket.lockRead();
            return result;
        }
        return this.readValues(file);
    }

    private List<Pair<Long, T>> readValues(FileInfo file) {
        try {
            byte[] buffer = this.getReadBuffer(file, 0, file.getSize()).getBuffer();
            if (file.getSize() > 0) {
                int expectedNumberOfLongValues = file.getSize() / 16;
                ArrayList<Pair<Long, T>> result = new ArrayList<Pair<Long, T>>(expectedNumberOfLongValues);
                if (!file.isDirty()) {
                    ReadValue<T> readValue;
                    for (int position = 0; position < buffer.length; position += readValue.getSize()) {
                        long key = SerializationUtils.bytesToLong((byte[])buffer, (int)position);
                        readValue = this.readValue(buffer, position += 8);
                        result.add(new Pair((Object)key, readValue.getValue()));
                    }
                    return result;
                }
                int numberOfBuckets = Math.max(1, expectedNumberOfLongValues / 1000);
                List[] buckets = new List[numberOfBuckets];
                for (int i = 0; i < buckets.length; ++i) {
                    buckets[i] = new ArrayList(expectedNumberOfLongValues / numberOfBuckets);
                }
                long start = file.getFirstKey();
                long density = 0x400000000000000L / (long)numberOfBuckets;
                int position = 0;
                while (position < buffer.length) {
                    long key = SerializationUtils.bytesToLong((byte[])buffer, (int)position);
                    ReadValue<T> readValue = this.readValue(buffer, position += 8);
                    position += readValue.getSize();
                    int bucketInd = (int)((key - start) / density);
                    if (bucketInd == buckets.length) {
                        --bucketInd;
                    }
                    if (bucketInd >= buckets.length) {
                        UI.write((String)"huh?");
                    }
                    buckets[bucketInd].add(new Pair((Object)key, readValue.getValue()));
                }
                for (int bucketInd = 0; bucketInd < buckets.length; ++bucketInd) {
                    List currentBucket = buckets[bucketInd];
                    Collections.sort(currentBucket, new Comparator<Pair<Long, T>>(){

                        @Override
                        public int compare(Pair<Long, T> o1, Pair<Long, T> o2) {
                            return Long.compare((Long)o1.getFirst(), (Long)o2.getFirst());
                        }
                    });
                    for (int i = 0; i < currentBucket.size(); ++i) {
                        long nextKey;
                        Pair currPair = (Pair)currentBucket.get(i);
                        long currKey = (Long)currPair.getFirst();
                        Object currVal = currPair.getSecond();
                        for (int j = i + 1; j < currentBucket.size() && (nextKey = ((Long)((Pair)currentBucket.get(j)).getFirst()).longValue()) == currKey; ++j) {
                            Object nextVal = ((Pair)currentBucket.get(j)).getSecond();
                            Object combinedVal = currVal == null || nextVal == null ? nextVal : this.getCombinator().combine(currVal, nextVal);
                            currPair.setSecond(combinedVal);
                            currVal = combinedVal;
                            ++i;
                        }
                        if (currPair.getSecond() == null) continue;
                        result.add(currPair);
                    }
                    buckets[bucketInd] = null;
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception while reading values from file " + this.toFile(file).getAbsolutePath(), ex);
        }
    }

    private FileIterator createFileIterator() {
        return new FileIterator();
    }

    private List<Long> readKeys(FileBucket bucket, FileInfo file) throws IOException {
        if (file.isDirty()) {
            List<Pair<Long, T>> values = this.readValuesWithCheck(bucket, file);
            ArrayList<Long> keys = new ArrayList<Long>();
            for (Pair<Long, T> value : values) {
                keys.add((Long)value.getFirst());
            }
            return keys;
        }
        return this.readKeysFromCleanFile(file);
    }

    private List<Long> readKeysFromCleanFile(FileInfo file) throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        if (file.getSize() == 0) {
            return result;
        }
        byte[] buffer = this.getReadBuffer(file, 0, file.getSize()).getBuffer();
        for (int position = 0; position < buffer.length; position += this.skipValue(buffer, position)) {
            result.add(SerializationUtils.bytesToLong((byte[])buffer, (int)position));
            position += 8;
        }
        return result;
    }

    private void deleteFile(FileInfo file) {
        boolean success = this.toFile(file).delete();
        if (!success) {
            throw new RuntimeException("Failed to delete file " + this.toFile(file).getAbsolutePath());
        }
    }

    private int sizeToInteger(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("Size too large!");
        }
        return (int)size;
    }

    private List<Pair<Long, Integer>> sample(List<Pair<Long, Integer>> fileLocations, int invSampleRate) {
        ArrayList<Pair<Long, Integer>> result = new ArrayList<Pair<Long, Integer>>(fileLocations.size() / invSampleRate);
        for (int i = 0; i < fileLocations.size(); ++i) {
            if (i % invSampleRate != 0) continue;
            result.add(fileLocations.get(i));
        }
        return result;
    }

    public void doOccasionalAction() {
        if (!this.wasClosed()) {
            this.writeCleanFilesListIfNecessary();
            this.checkLock();
        }
    }

    private void checkLock() {
        File lockFile = new File(this.directory, LOCK_FILE);
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(lockFile));
            long id = dis.readLong();
            IOUtils.closeQuietly((InputStream)dis);
            if (this.randomId != id) {
                this.writeLockFile(new Random().nextLong());
                UI.writeError((String)("The lock in " + lockFile.getAbsolutePath() + " was obtained by another data interface! Closing data interface. This will probably cause a lot of other errors..."));
                this.close();
            }
        }
        catch (Exception exp) {
            throw new RuntimeException("Unexpected exception while trying to read lock file " + lockFile.getAbsolutePath());
        }
    }

    private class FileIterator {
        private int currentBucketInd = 0;
        private int fileInd = 0;

        private FileIterator() {
        }

        public Pair<FileBucket, FileInfo> lockCurrentBucketAndGetNextFile() {
            if (this.currentBucketInd < FileDataInterface.this.fileBuckets.length) {
                FileBucket bucket = FileDataInterface.this.fileBuckets[this.currentBucketInd];
                bucket.lockRead();
                while (this.currentBucketInd < FileDataInterface.this.fileBuckets.length && this.fileInd >= bucket.getFiles().size()) {
                    this.fileInd = 0;
                    bucket.unlockRead();
                    ++this.currentBucketInd;
                    if (this.currentBucketInd >= FileDataInterface.this.fileBuckets.length) continue;
                    bucket = FileDataInterface.this.fileBuckets[this.currentBucketInd];
                    bucket.lockRead();
                }
                if (this.currentBucketInd < FileDataInterface.this.fileBuckets.length) {
                    return new Pair((Object)bucket, (Object)bucket.getFiles().get(this.fileInd++));
                }
            }
            return null;
        }
    }

    private static class ReadValue<T> {
        private int size;
        private T value;

        private ReadValue(int size, T value) {
            this.size = size;
            this.value = value;
        }

        public int getSize() {
            return this.size;
        }

        public T getValue() {
            return this.value;
        }
    }

    private static class ReadBuffer {
        private final byte[] buffer;
        private final int offset;

        private ReadBuffer(byte[] buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

