/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.filedb;

import be.bagofwords.db.filedb.FileInfo;
import be.bagofwords.ui.UI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;

public class FileBucket
implements Comparable<FileBucket> {
    private static final int NUMBER_OF_READ_PERMITS = 1000;
    private final long firstKey;
    private final long lastKey;
    private final List<FileInfo> files;
    private final Semaphore lock;

    public FileBucket(long firstKey, long lastKey) {
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.files = new ArrayList<FileInfo>();
        this.lock = new Semaphore(1000);
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public int getFileInd(long key) {
        int pos = Collections.binarySearch(this.files, key);
        if (pos < 0) {
            pos = -(pos + 2);
        }
        if (pos == -1) {
            UI.write((String)"ARRAY INDEX OUT OF BOUNDS!!!!");
            UI.write((String)("Was looking for key " + key));
            UI.write((String)("In bucket starting with key " + this.getFirstKey()));
            UI.write((String)"In files ");
            for (FileInfo file : this.files) {
                UI.write((String)("   " + file.getFirstKey()));
            }
        }
        return pos;
    }

    public long getFirstKey() {
        return this.firstKey;
    }

    public FileInfo getFile(long key) {
        return this.files.get(this.getFileInd(key));
    }

    public long getLastKey() {
        return this.lastKey;
    }

    public void unlockWrite() {
        this.lock.release(1000);
        if (this.lock.availablePermits() > 1000) {
            throw new RuntimeException("Illegal state of lock: too many unlocks");
        }
    }

    public void lockWrite() {
        this.lock.acquireUninterruptibly(1000);
    }

    public void unlockRead() {
        this.lock.release(1);
        if (this.lock.availablePermits() > 1000) {
            throw new RuntimeException("Illegal state of lock: too many unlocks");
        }
    }

    public void lockRead() {
        this.lock.acquireUninterruptibly(1);
    }

    public boolean tryLockRead() {
        return this.lock.tryAcquire(1);
    }

    public String toString() {
        return super.toString() + " " + this.firstKey + ", permits=" + this.lock.availablePermits();
    }

    @Override
    public int compareTo(FileBucket o) {
        return Long.compare(this.firstKey, o.getFirstKey());
    }
}

