/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.rocksdb;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.experimental.rocksdb.RocksDBDataInterface;
import be.bagofwords.util.Utils;
import java.io.File;
import org.rocksdb.RocksDB;

public class RocksDBDataInterfaceFactory
extends DataInterfaceFactory {
    private final String directory;
    private final boolean usePatch;

    public RocksDBDataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, String directory, boolean usePatch) {
        super(cachesManager, memoryManager);
        this.directory = directory;
        this.usePatch = usePatch;
        File libFile = this.findLibFile();
        if (libFile == null) {
            throw new RuntimeException("Could not find librocksdbjni.so");
        }
        Utils.addLibraryPath((String)libFile.getParentFile().getAbsolutePath());
        RocksDB.loadLibrary();
    }

    private File findLibFile() {
        File libFile = new File("./lib/rocksdb/linux-x86_64/librocksdbjni.so");
        if (libFile.exists()) {
            return libFile;
        }
        libFile = new File("./count-db/lib/rocksdb/linux-x86_64/librocksdbjni.so");
        if (libFile.exists()) {
            return libFile;
        }
        return null;
    }

    @Override
    protected <T> DataInterface<T> createBaseDataInterface(String nameOfSubset, Class<T> objectClass, Combinator<T> combinator) {
        return new RocksDBDataInterface<T>(nameOfSubset, objectClass, combinator, this.directory, this.usePatch);
    }
}

