/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.rocksdb;

import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.DataLock;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.SerializationUtils;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBDataInterface<T>
extends CoreDataInterface<T> {
    private final boolean useMergeHack;
    private final DataLock writeLock;
    private final WriteOptions delayedWriteOptions;
    private final File dbDirectory;
    private RocksDB db;

    public RocksDBDataInterface(String name, Class<T> objectClass, Combinator<T> combinator, String directory, boolean usePatch) {
        super(name, objectClass, combinator);
        this.useMergeHack = usePatch;
        try {
            boolean success;
            if (this.useMergeHack && objectClass == Long.class) {
                name = "_long_count_" + name;
            }
            this.dbDirectory = new File(new File(directory), name);
            if (this.dbDirectory.isFile()) {
                throw new RuntimeException(this.dbDirectory.getAbsolutePath() + " is a file, should be a directory...");
            }
            if (!this.dbDirectory.exists() && !(success = this.dbDirectory.mkdirs())) {
                throw new RuntimeException("Failed to create directory " + this.dbDirectory.getAbsolutePath());
            }
            this.openDatabase();
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Failed to create database", e);
        }
        this.writeLock = new DataLock();
        this.delayedWriteOptions = new WriteOptions();
    }

    private void openDatabase() throws RocksDBException {
        Options options = new Options().setCreateIfMissing(true);
        this.db = RocksDB.open((Options)options, (String)this.dbDirectory.getAbsolutePath());
    }

    @Override
    protected void writeInt0(Iterator<KeyValue<T>> entries) {
        this.writeLock.lockWriteAll();
        try {
            WriteBatch writeBatch = new WriteBatch();
            if (this.useMergeHack && this.getObjectClass() == Long.class) {
                while (entries.hasNext()) {
                    KeyValue<T> next = entries.next();
                    byte[] keyAsBytes = SerializationUtils.longToBytes((long)next.getKey());
                    if (next.getValue() == null) {
                        writeBatch.remove(keyAsBytes);
                        continue;
                    }
                    writeBatch.merge(keyAsBytes, SerializationUtils.objectToBytes((Object)next.getValue(), this.getObjectClass()));
                }
            } else {
                while (entries.hasNext()) {
                    KeyValue<T> next = entries.next();
                    byte[] keyAsBytes = SerializationUtils.longToBytes((long)next.getKey());
                    Object combinedValue = this.combineWithCurrentValue(next.getValue(), keyAsBytes);
                    if (combinedValue == null) {
                        writeBatch.remove(keyAsBytes);
                        continue;
                    }
                    writeBatch.put(keyAsBytes, SerializationUtils.objectToBytes((Object)combinedValue, this.getObjectClass()));
                }
            }
            this.db.write(this.delayedWriteOptions, writeBatch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Received exception while trying to write multiple values to the DB", e);
        }
        finally {
            this.writeLock.unlockWriteAll();
        }
    }

    @Override
    protected void writeInt0(long key, T value) {
        byte[] keyAsBytes = SerializationUtils.longToBytes((long)key);
        this.writeLock.lockWrite(key);
        try {
            T combinedValue = this.combineWithCurrentValue(value, keyAsBytes);
            if (combinedValue == null) {
                this.db.remove(this.delayedWriteOptions, keyAsBytes);
            } else {
                this.db.put(this.delayedWriteOptions, keyAsBytes, SerializationUtils.objectToBytes(combinedValue, this.getObjectClass()));
            }
        }
        catch (RocksDBException exp) {
            throw new RuntimeException("Received exception while trying to write a single value to the DB", exp);
        }
        finally {
            this.writeLock.unlockWrite(key);
        }
    }

    private T combineWithCurrentValue(T value, byte[] keyAsBytes) throws RocksDBException {
        Object currentValue = SerializationUtils.bytesToObject((byte[])this.db.get(keyAsBytes), this.getObjectClass());
        Object combinedValue = currentValue == null || value == null ? value : this.getCombinator().combine(currentValue, value);
        return combinedValue;
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        final RocksIterator rocksIterator = this.db.newIterator();
        rocksIterator.seekToFirst();
        return new CloseableIterator<KeyValue<T>>(){

            protected void closeInt() {
                rocksIterator.dispose();
            }

            public boolean hasNext() {
                return rocksIterator.isValid();
            }

            public KeyValue<T> next() {
                long key = SerializationUtils.bytesToLong((byte[])rocksIterator.key());
                Object value = SerializationUtils.bytesToObject((byte[])rocksIterator.value(), RocksDBDataInterface.this.getObjectClass());
                rocksIterator.next();
                return new KeyValue(key, value);
            }
        };
    }

    @Override
    public void optimizeForReading() {
    }

    @Override
    public T read(long key) {
        this.writeLock.lockRead(key);
        try {
            Object result;
            Object object = result = SerializationUtils.bytesToObject((byte[])this.db.get(SerializationUtils.longToBytes((long)key)), this.getObjectClass());
            return (T)object;
        }
        catch (RocksDBException e) {
            throw new RuntimeException("Received exception while reading single value", e);
        }
        finally {
            this.writeLock.unlockRead(key);
        }
    }

    @Override
    public synchronized void dropAllData() {
        this.writeLock.lockWriteAll();
        this.db.close();
        try {
            FileUtils.deleteDirectory((File)this.dbDirectory);
            this.openDatabase();
        }
        catch (Exception exp) {
            throw new RuntimeException("Failed to drop all data", exp);
        }
        this.writeLock.unlockWriteAll();
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void doClose() {
        this.db.close();
        this.db = null;
    }

    @Override
    public long apprSize() {
        return this.exactSize();
    }
}

