/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.lmdb;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.experimental.lmdb.LMDBDataInterface;
import java.io.File;
import org.fusesource.lmdbjni.Env;

public class LMDBDataInterfaceFactory
extends DataInterfaceFactory {
    private Env env = new Env();
    private String directory;

    public LMDBDataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, String directory) {
        super(cachesManager, memoryManager);
        boolean success;
        this.env.setMaxDbs(100L);
        this.env.setMapSize(0xC800000L);
        File directoryAsFile = new File(directory);
        if (directoryAsFile.isFile()) {
            throw new RuntimeException("Path " + directoryAsFile.getAbsolutePath() + " is a file! Expected a directory...");
        }
        if (!directoryAsFile.exists() && !(success = directoryAsFile.mkdirs())) {
            throw new RuntimeException("Failed to create directory " + directoryAsFile.getAbsolutePath());
        }
        this.env.open(directory);
    }

    @Override
    protected <T> DataInterface<T> createBaseDataInterface(String nameOfSubset, Class<T> objectClass, Combinator<T> combinator) {
        return new LMDBDataInterface<T>(nameOfSubset, objectClass, combinator, this.env);
    }

    @Override
    public synchronized void terminate() {
        super.terminate();
        this.env.close();
    }
}

