/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.lmdb;

import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.DataLock;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.SerializationUtils;
import java.util.Arrays;
import java.util.Iterator;
import org.fusesource.lmdbjni.Cursor;
import org.fusesource.lmdbjni.Database;
import org.fusesource.lmdbjni.Entry;
import org.fusesource.lmdbjni.Env;
import org.fusesource.lmdbjni.GetOp;
import org.fusesource.lmdbjni.Transaction;

public class LMDBDataInterface<T>
extends CoreDataInterface<T> {
    private final Env env;
    private final DataLock dataLock;
    private Database db;

    public LMDBDataInterface(String name, Class<T> objectClass, Combinator<T> combinator, Env env) {
        super(name, objectClass, combinator);
        this.db = env.openDatabase(name);
        this.env = env;
        this.dataLock = new DataLock(false);
    }

    @Override
    protected void writeInt0(Iterator<KeyValue<T>> entries) {
        Transaction transaction = this.env.createTransaction();
        long numberOfValuesWritten = 0L;
        while (entries.hasNext()) {
            KeyValue<T> next = entries.next();
            try {
                this.writeWithTransaction(next.getKey(), next.getValue(), transaction);
            }
            catch (Exception exp) {
                throw new RuntimeException("Failed to write multiple entries after " + numberOfValuesWritten + " values", exp);
            }
            if (++numberOfValuesWritten <= 1000L) continue;
            transaction.commit();
            transaction = this.env.createTransaction();
            numberOfValuesWritten = 0L;
        }
        transaction.commit();
    }

    @Override
    protected void writeInt0(long key, T value) {
        Transaction transaction = this.env.createTransaction();
        this.writeWithTransaction(key, value, transaction);
        transaction.commit();
    }

    private void writeWithTransaction(long key, T value, Transaction transaction) {
        this.dataLock.lockWrite(key);
        byte[] keysAsBytes = SerializationUtils.longToBytes((long)key);
        try {
            Object currentValue = SerializationUtils.bytesToObject((byte[])this.db.get(transaction, keysAsBytes), this.getObjectClass());
            Object combinedValue = currentValue == null || value == null ? value : this.getCombinator().combine(currentValue, value);
            if (combinedValue == null) {
                this.db.delete(transaction, keysAsBytes);
            } else {
                this.db.put(transaction, keysAsBytes, SerializationUtils.objectToBytes(combinedValue, this.getObjectClass()));
            }
        }
        catch (Exception exp) {
            throw new RuntimeException("Error while trying to write key " + key + "(=" + Arrays.toString(keysAsBytes) + ") with value " + value, exp);
        }
        finally {
            this.dataLock.unlockWrite(key);
        }
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        final Transaction transaction = this.env.createTransaction();
        final Cursor cursor = this.db.openCursor(transaction);
        return new CloseableIterator<KeyValue<T>>(){
            private Entry next;
            {
                this.next = cursor.get(GetOp.FIRST);
            }

            protected void closeInt() {
                cursor.close();
                transaction.commit();
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public KeyValue<T> next() {
                KeyValue result = new KeyValue(SerializationUtils.bytesToLong((byte[])this.next.getKey()), SerializationUtils.bytesToObject((byte[])this.next.getValue(), LMDBDataInterface.this.getObjectClass()));
                this.next = cursor.get(GetOp.NEXT);
                return result;
            }
        };
    }

    @Override
    public void optimizeForReading() {
    }

    @Override
    public T read(long key) {
        byte[] resultAsBytes = this.db.get(SerializationUtils.longToBytes((long)key));
        return (T)SerializationUtils.bytesToObject((byte[])resultAsBytes, this.getObjectClass());
    }

    @Override
    public void dropAllData() {
        this.dataLock.lockWriteAll();
        this.db.drop(false);
        this.dataLock.unlockWriteAll();
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void doClose() {
        this.dataLock.lockWriteAll();
        this.db.close();
        this.dataLock.unlockWriteAll();
    }

    @Override
    public long apprSize() {
        return this.exactSize();
    }
}

