/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.kyoto;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.experimental.kyoto.KyotoDataInterface;
import be.bagofwords.util.Utils;
import java.io.File;

public class KyotoDataInterfaceFactory
extends DataInterfaceFactory {
    private final String directory;

    public KyotoDataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager, String directory) {
        super(cachesManager, memoryManager);
        this.directory = directory;
        File libFile = this.findLibFile();
        if (libFile == null) {
            throw new RuntimeException("Could not find libkyotocabinet.so.16");
        }
        System.load(libFile.getAbsolutePath());
        Utils.addLibraryPath((String)libFile.getParentFile().getAbsolutePath());
    }

    private File findLibFile() {
        File libFile = new File("./lib/kyotocabinet-1.24/linux-x86_64/libkyotocabinet.so.16");
        if (libFile.exists()) {
            return libFile;
        }
        libFile = new File("./count-db/lib/kyotocabinet-1.24/linux-x86_64/libkyotocabinet.so.16");
        if (libFile.exists()) {
            return libFile;
        }
        return null;
    }

    @Override
    protected <T> DataInterface<T> createBaseDataInterface(String nameOfSubset, Class<T> objectClass, Combinator<T> combinator) {
        return new KyotoDataInterface<T>(nameOfSubset, this.directory, objectClass, combinator);
    }
}

