/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.kyoto;

import be.bagofwords.db.CoreDataInterface;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.combinator.LongCombinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.SerializationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kyotocabinet.Cursor;
import kyotocabinet.DB;

public class KyotoDataInterface<T>
extends CoreDataInterface<T> {
    private static final int BATCH_SIZE = 10000;
    private DB db = new DB();

    protected KyotoDataInterface(String name, String path, Class<T> objectClass, Combinator<T> combinator) {
        super(name, objectClass, combinator);
        boolean success;
        File file = new File(new File(path), name + ".kcf");
        File parentDir = file.getParentFile();
        if (parentDir.isFile()) {
            throw new RuntimeException("Path " + parentDir.getAbsolutePath() + " is a file!");
        }
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!(success = this.db.open(file.getAbsolutePath(), 7))) {
            throw new RuntimeException("Failed to open Kyoto DB at " + file.getAbsolutePath());
        }
    }

    @Override
    public T read(long key) {
        byte[] bytes = this.db.get(SerializationUtils.longToBytes((long)key));
        return (T)SerializationUtils.bytesToObject((byte[])bytes, this.getObjectClass());
    }

    @Override
    public void writeInt0(long key, T value) {
        byte[] keyAsBytes = SerializationUtils.longToBytes((long)key);
        if (value == null) {
            this.db.remove(keyAsBytes);
        } else if (this.getCombinator() instanceof LongCombinator) {
            this.db.increment(keyAsBytes, ((Long)value).longValue(), 0L);
        } else {
            Object currentValue = SerializationUtils.bytesToObject((byte[])this.db.get(keyAsBytes), this.getObjectClass());
            Object valueToWrite = currentValue == null ? value : this.getCombinator().combine(currentValue, value);
            byte[] valueAsBytes = SerializationUtils.objectToBytes(valueToWrite, this.getObjectClass());
            this.db.set(keyAsBytes, valueAsBytes);
        }
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        final Cursor cursor = this.db.cursor();
        return new CloseableIterator<KeyValue<T>>(){
            private boolean hasNext;
            {
                this.hasNext = cursor.jump();
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public KeyValue<T> next() {
                byte[][] keyAndVal = cursor.get(false);
                this.hasNext = cursor.step();
                if (!this.hasNext) {
                    this.close();
                }
                return new KeyValue(SerializationUtils.bytesToLong((byte[])keyAndVal[0]), SerializationUtils.bytesToObject((byte[])keyAndVal[1], KyotoDataInterface.this.getObjectClass()));
            }

            public void remove() {
                throw new RuntimeException("Not impemented!");
            }

            public void closeInt() {
                if (this.hasNext && KyotoDataInterface.this.db != null) {
                    cursor.disable();
                }
            }
        };
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator(final Iterator<Long> keyIterator) {
        return new CloseableIterator<KeyValue<T>>(){
            private Iterator<KeyValue<T>> valueBatch;
            {
                this.findNextBatch();
            }

            private void findNextBatch() {
                ArrayList keys = new ArrayList();
                while (keyIterator.hasNext() && keys.size() < 10000) {
                    keys.add(keyIterator.next());
                }
                if (!keys.isEmpty()) {
                    byte[][] keysAsBytes = new byte[keys.size()][];
                    for (int i = 0; i < keys.size(); ++i) {
                        keysAsBytes[i] = SerializationUtils.longToBytes((long)((Long)keys.get(i)));
                    }
                    byte[][] keysAndValues = KyotoDataInterface.this.db.get_bulk((byte[][])keysAsBytes, false);
                    HashMap<Long, Object> parsedValues = new HashMap<Long, Object>();
                    for (int i = 0; i < keysAndValues.length; i += 2) {
                        long key = SerializationUtils.bytesToLong((byte[])keysAndValues[i]);
                        Object value = SerializationUtils.bytesToObject((byte[])keysAndValues[i + 1], KyotoDataInterface.this.getObjectClass());
                        parsedValues.put(key, value);
                    }
                    ArrayList<KeyValue> allValues = new ArrayList<KeyValue>();
                    for (Long key : keys) {
                        allValues.add(new KeyValue(key.longValue(), parsedValues.get(key)));
                    }
                    this.valueBatch = allValues.iterator();
                } else {
                    this.valueBatch = null;
                }
            }

            public boolean hasNext() {
                return this.valueBatch != null;
            }

            public KeyValue<T> next() {
                KeyValue next = this.valueBatch.next();
                if (!this.valueBatch.hasNext()) {
                    this.findNextBatch();
                }
                return next;
            }

            public void closeInt() {
            }
        };
    }

    @Override
    public void optimizeForReading() {
    }

    @Override
    public void writeInt0(Iterator<KeyValue<T>> entries) {
        while (entries.hasNext()) {
            HashMap<Long, Object> valuesToWrite = new HashMap<Long, Object>();
            ArrayList<Long> valuesToDelete = new ArrayList<Long>();
            for (int numOfValues = 0; numOfValues < 10000 && entries.hasNext(); ++numOfValues) {
                KeyValue<T> entry = entries.next();
                if (entry.getValue() == null) {
                    valuesToDelete.add(entry.getKey());
                    continue;
                }
                valuesToWrite.put(entry.getKey(), entry.getValue());
            }
            this.bulkDelete(valuesToDelete);
            this.bulkWrite(valuesToWrite);
        }
    }

    private void bulkWrite(Map<Long, T> valuesToWrite) {
        HashMap<Long, Object> currentValues = new HashMap<Long, Object>();
        CloseableIterator<KeyValue<T>> valueIt = this.iterator(valuesToWrite.keySet().iterator());
        while (valueIt.hasNext()) {
            KeyValue curr = (KeyValue)valueIt.next();
            if (curr.getValue() == null) continue;
            currentValues.put(curr.getKey(), curr.getValue());
        }
        valueIt.close();
        byte[][] keysAndValues = new byte[valuesToWrite.size() * 2][];
        int ind = 0;
        for (Map.Entry<Long, T> value : valuesToWrite.entrySet()) {
            Object currentValue = currentValues.get(value.getKey());
            T valueToWrite = currentValue == null ? value.getValue() : this.getCombinator().combine(currentValue, value.getValue());
            keysAndValues[ind] = SerializationUtils.longToBytes((long)value.getKey());
            keysAndValues[ind + 1] = SerializationUtils.objectToBytes(valueToWrite, this.getObjectClass());
            ind += 2;
        }
        this.db.set_bulk((byte[][])keysAndValues, false);
    }

    private void bulkDelete(List<Long> valuesToDelete) {
        if (valuesToDelete.size() > 0) {
            byte[][] allKeys = new byte[valuesToDelete.size()][];
            for (int i = 0; i < valuesToDelete.size(); ++i) {
                allKeys[i] = SerializationUtils.longToBytes((long)valuesToDelete.get(i));
            }
            this.db.remove_bulk((byte[][])allKeys, false);
        }
    }

    @Override
    public void dropAllData() {
        this.db.clear();
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        KyotoDataInterface kyotoDataInterface = this;
        synchronized (kyotoDataInterface) {
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public DataInterface getImplementingDataInterface() {
        return null;
    }

    @Override
    public long apprSize() {
        return this.db.count();
    }
}

