/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.experimental.index;

import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.LayeredDataInterface;
import be.bagofwords.db.data.LongList;
import be.bagofwords.db.data.LongListCombinator;
import be.bagofwords.db.experimental.index.DataIndexer;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.KeyValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexedDataInterface<T>
extends LayeredDataInterface<T> {
    private final DataIndexer<T> indexer;
    private final DataInterface<LongList> indexedDataInterface;

    public IndexedDataInterface(DataInterfaceFactory dataInterfaceFactory, DataInterface<T> baseInterface, DataIndexer<T> indexer) {
        super(baseInterface);
        this.indexer = indexer;
        this.indexedDataInterface = dataInterfaceFactory.createDataInterface(DatabaseCachingType.CACHED_AND_BLOOM, baseInterface.getName() + "_idx", LongList.class, new LongListCombinator());
    }

    @Override
    public void write(long key, T value) {
        this.baseInterface.write(key, value);
        for (long indexKey : this.indexer.convertToIndexes(value)) {
            this.indexedDataInterface.write(indexKey, new LongList(key));
        }
    }

    public void rebuildIndex() {
        this.indexedDataInterface.dropAllData();
        CloseableIterator it = this.baseInterface.iterator();
        while (it.hasNext()) {
            KeyValue curr = (KeyValue)it.next();
            Object value = curr.getValue();
            for (long indexKey : this.indexer.convertToIndexes(value)) {
                this.indexedDataInterface.write(indexKey, new LongList(curr.getKey()));
            }
        }
        it.close();
        this.indexedDataInterface.flush();
    }

    public List<T> readIndexedValues(long indexKey) {
        LongList keys = this.indexedDataInterface.read(indexKey);
        ArrayList result = new ArrayList();
        if (keys != null) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                long key = (Long)iterator.next();
                Object value = this.baseInterface.read(key);
                if (value == null || !this.indexer.convertToIndexes(value).contains(indexKey)) continue;
                result.add(value);
            }
        }
        return result;
    }

    @Override
    public void dropAllData() {
        this.baseInterface.dropAllData();
        this.indexedDataInterface.dropAllData();
    }

    @Override
    public void flush() {
        this.baseInterface.flush();
        this.indexedDataInterface.flush();
    }

    @Override
    protected void doClose() {
        this.indexedDataInterface.close();
    }
}

