/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.util.HashUtils;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.Serializable;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"dataCheckSum"})
public class LongCountsBloomFilter
implements Serializable {
    private int numOfHashFunctions;
    private ByteArray bytes;

    public LongCountsBloomFilter(long expectedSize, double fpp) {
        if (expectedSize > Integer.MAX_VALUE) {
            throw new RuntimeException("Creating a bloomfilter currently not supported for size " + expectedSize);
        }
        int numOfBytes = LongCountsBloomFilter.optimalNumOfBytes(expectedSize, fpp);
        this.bytes = new ByteArray(numOfBytes);
        this.numOfHashFunctions = LongCountsBloomFilter.optimalNumOfHashFunctions(expectedSize, numOfBytes);
    }

    public LongCountsBloomFilter(ByteArray bytes, int numOfHashFunctions) {
        this.bytes = bytes;
        this.numOfHashFunctions = numOfHashFunctions;
    }

    public int getMaxCount(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        if (hash1 == 0 || hash2 == 0) {
            hash64 = HashUtils.randomDistributeHash((long)hash64);
            hash1 = (int)hash64;
            hash2 = (int)(hash64 >>> 32);
        }
        int min = 255;
        for (int i = 1; i <= this.numOfHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            min = Math.min(min, this.bytes.get(nextHash % this.bytes.size()));
        }
        return min;
    }

    public synchronized <T> void addCount(long hash64, int count) {
        int currCount = this.getMaxCount(hash64);
        int newCount = Math.min(count + currCount, 255);
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        if (hash1 == 0 || hash2 == 0) {
            hash64 = HashUtils.randomDistributeHash((long)hash64);
            hash1 = (int)hash64;
            hash2 = (int)(hash64 >>> 32);
        }
        for (int i = 1; i <= this.numOfHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            this.bytes.set(nextHash % this.bytes.size(), newCount);
        }
    }

    private static int optimalNumOfBytes(long expectedSize, double fpp) {
        double result;
        if (fpp == 0.0) {
            fpp = Double.MIN_VALUE;
        }
        if ((result = (double)(-expectedSize) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0))) > 2.147483647E9) {
            throw new RuntimeException("Number of required bytes too large!");
        }
        return (int)result;
    }

    private static int optimalNumOfHashFunctions(long expectedSize, long numOfBytes) {
        if (expectedSize == 0L) {
            expectedSize = 1L;
        }
        return Math.max(1, (int)Math.round((double)(numOfBytes / expectedSize) * Math.log(2.0)));
    }

    public LongCountsBloomFilter() {
    }

    public int getNumOfHashFunctions() {
        return this.numOfHashFunctions;
    }

    public void setNumOfHashFunctions(int numOfHashFunctions) {
        this.numOfHashFunctions = numOfHashFunctions;
    }

    public double expectedFpp() {
        return Math.pow((double)this.bytes.computeBitCount() / (double)this.bytes.size(), this.numOfHashFunctions);
    }

    public LongCountsBloomFilter clone() {
        return new LongCountsBloomFilter(this.getBytes().clone(), this.numOfHashFunctions);
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    public void setBytes(ByteArray bytes) {
        this.bytes = bytes;
    }

    private byte max(byte val1, byte val2) {
        if (val1 > val2) {
            return val1;
        }
        return val2;
    }

    public class ByteArray {
        private byte[] data;

        public ByteArray(int bits) {
            this.data = new byte[bits];
            Arrays.fill(this.data, (byte)-128);
        }

        public ByteArray(byte[] data) {
            this.data = data;
        }

        void set(int index, int value) {
            if (value < 0) {
                throw new RuntimeException("Can not set negative counts!");
            }
            int valueToSet = value + -128;
            if (valueToSet > 127) {
                throw new RuntimeException("Too large count " + value);
            }
            this.data[index] = LongCountsBloomFilter.this.max(this.data[index], (byte)valueToSet);
        }

        int get(int index) {
            return this.data[index] - -128;
        }

        public int size() {
            return this.data.length;
        }

        int computeBitCount() {
            int bitCount = 0;
            for (byte aData : this.data) {
                if (aData == -128) continue;
                ++bitCount;
            }
            return bitCount;
        }

        public ByteArray() {
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public ByteArray mergeWith(ByteArray otherByteArray) {
            if (otherByteArray.size() != this.size()) {
                throw new RuntimeException("Unequal sizes!");
            }
            ByteArray result = new ByteArray(this.size());
            for (int i = 0; i < this.data.length; ++i) {
                int sum = this.data[i] + otherByteArray.data[i] - -128;
                if (sum > 127) {
                    sum = 127;
                }
                result.data[i] = (byte)sum;
            }
            return result;
        }

        public ByteArray clone() {
            return new ByteArray((byte[])this.data.clone());
        }
    }

    public static class LongFunnel
    implements Funnel<Long> {
        public void funnel(Long s, PrimitiveSink primitiveSink) {
            primitiveSink.putLong(s.longValue());
        }
    }
}

