/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.util.Compactable;
import be.bagofwords.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class CountsList
extends ArrayList<Pair<Long, Long>>
implements Compactable {
    public static final long DISCRETE_FACTOR = 1000000L;

    public CountsList() {
    }

    public CountsList(CountsList list) {
        super(list);
    }

    public CountsList(long key, int count) {
        this();
        this.addCount(key, count);
    }

    public CountsList(int initialSize) {
        super(initialSize);
    }

    public synchronized long getCount(long key) {
        int ind = Collections.binarySearch(this, key);
        if (ind >= 0) {
            return (Long)((Pair)this.get(ind)).getSecond();
        }
        return 0L;
    }

    public synchronized void addCount(long key, long count) {
        this.add(new Pair((Object)key, (Object)count));
    }

    @JsonIgnore
    public synchronized double getTotal() {
        double total = 0.0;
        for (Pair value : this) {
            total += (double)((Long)value.getSecond()).longValue();
        }
        return total;
    }

    @Override
    public synchronized CountsList clone() {
        CountsList clone = new CountsList();
        for (Pair value : this) {
            clone.add(value.clone());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        if (!this.isCompacted()) {
            CountsList countsList = this;
            synchronized (countsList) {
                if (!this.isCompacted()) {
                    ArrayList<Pair<Long, Long>> oldCounts = new ArrayList<Pair<Long, Long>>(this);
                    this.clear();
                    Collections.sort(oldCounts);
                    int i = 0;
                    while (i < oldCounts.size()) {
                        Pair curr = (Pair)oldCounts.get(i);
                        long combinedCount = (Long)curr.getSecond();
                        ++i;
                        while (i < oldCounts.size() && ((Long)((Pair)oldCounts.get(i)).getFirst()).equals(curr.getFirst())) {
                            combinedCount += ((Long)((Pair)oldCounts.get(i++)).getSecond()).longValue();
                        }
                        this.add(new Pair(curr.getFirst(), (Object)combinedCount));
                    }
                }
            }
        }
    }

    private boolean isCompacted() {
        for (int i = 1; i < this.size(); ++i) {
            if ((Long)((Pair)this.get(i - 1)).getFirst() < (Long)((Pair)this.get(i)).getFirst()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        int result = 5381;
        for (Pair value : this) {
            result = result * 65599 + ((Long)value.getFirst()).intValue();
            result = result * 65599 + ((Long)value.getSecond()).hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        int i;
        String result = "{ ";
        for (i = 0; i < this.size() && i < 10; ++i) {
            result = result + ((Pair)this.get(i)).getFirst() + ":" + ((Pair)this.get(i)).getSecond();
            if (i >= this.size() - 1) continue;
            result = result + ", ";
        }
        if (i < this.size()) {
            result = result + " ...";
        }
        result = result + "}";
        return result;
    }

    public void addDoubleCount(long key, double count) {
        long longCount = (long)(count * 1000000.0);
        this.addCount(key, longCount);
    }

    public double getDoubleCount(long key) {
        Long longCount = this.getCount(key);
        return (double)longCount.longValue() / 1000000.0;
    }

    public List<Long> getSortedKeys() {
        ArrayList<Pair<Long, Long>> sortedValues = new ArrayList<Pair<Long, Long>>(this);
        Collections.sort(sortedValues, new Comparator<Pair<Long, Long>>(){

            @Override
            public int compare(Pair<Long, Long> val1, Pair<Long, Long> val2) {
                if (((Long)val1.getSecond()).equals(val2.getSecond())) {
                    return Long.compare((Long)val1.getFirst(), (Long)val2.getFirst());
                }
                return -Long.compare((Long)val1.getSecond(), (Long)val2.getSecond());
            }
        });
        ArrayList<Long> result = new ArrayList<Long>();
        for (Pair pair : sortedValues) {
            result.add((Long)pair.getFirst());
        }
        return result;
    }
}

