/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.db.bloomfilter.LongBloomFilter;
import be.bagofwords.db.data.ApproximateCountsUtils;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class CompactIndex {
    public static final double FPP = 0.01;
    private int numberOfCounts;
    private long numberOfFeatures;
    private List<Long> cachedKeys;
    private LongBloomFilter filterCounts;

    public CompactIndex(long numberOfFeatures, int numberOfCounts) {
        this.cachedKeys = new ArrayList<Long>();
        this.numberOfFeatures = numberOfFeatures;
        this.numberOfCounts = numberOfCounts;
    }

    public CompactIndex(long numberOfFeatures, LongBloomFilter filterCounts, int numberOfCounts) {
        this.numberOfFeatures = numberOfFeatures;
        this.filterCounts = filterCounts;
        this.numberOfCounts = numberOfCounts;
    }

    public CompactIndex() {
    }

    @JsonIgnore
    public boolean isSparse() {
        return this.filterCounts == null;
    }

    public void addKey(long key) {
        ++this.numberOfCounts;
        if (this.isSparse()) {
            this.cachedKeys.add(key);
        } else {
            this.filterCounts.put(key);
        }
    }

    public long getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    public void setNumberOfFeatures(long numberOfFeatures) {
        this.numberOfFeatures = numberOfFeatures;
    }

    public List<Long> getCachedKeys() {
        return this.cachedKeys;
    }

    public void setCachedKeys(List<Long> cachedKeys) {
        this.cachedKeys = cachedKeys;
    }

    public LongBloomFilter getFilterCounts() {
        return this.filterCounts;
    }

    public void setFilterCounts(LongBloomFilter filterCounts) {
        this.filterCounts = filterCounts;
    }

    public int getNumberOfCounts() {
        return this.numberOfCounts;
    }

    public void setNumberOfCounts(int numberOfCounts) {
        this.numberOfCounts = numberOfCounts;
    }

    public boolean mightContain(long key) {
        if (this.isSparse()) {
            return this.cachedKeys.contains(key);
        }
        return this.filterCounts.mightContain(key);
    }

    public void makeNonSparse() {
        this.filterCounts = new LongBloomFilter(this.numberOfFeatures, 0.01);
        for (Long key : this.cachedKeys) {
            this.filterCounts.put(key);
        }
        this.cachedKeys = null;
    }

    public CompactIndex mergeWith(CompactIndex second) {
        CompactIndex result;
        boolean makeSparse;
        long maxSizeForSparse = this.getNumberOfFeatures() / 10L;
        boolean bl = makeSparse = this.isSparse() && second.isSparse() && (long)(this.getCachedKeys().size() + second.getCachedKeys().size()) < maxSizeForSparse;
        if (makeSparse) {
            result = new CompactIndex(this.getNumberOfFeatures(), this.getNumberOfCounts() + second.getNumberOfCounts());
            result.setCachedKeys(new ArrayList<Long>(this.getCachedKeys()));
            for (Long key : second.getCachedKeys()) {
                result.addKey(key);
            }
        } else {
            LongBloomFilter mergedCounts = !this.isSparse() && !second.isSparse() ? ApproximateCountsUtils.mergeBloomFilters(this.getFilterCounts(), second.getFilterCounts()) : (!this.isSparse() ? this.getFilterCounts().clone() : (!second.isSparse() ? second.getFilterCounts().clone() : new LongBloomFilter(this.getNumberOfFeatures(), 0.01)));
            if (this.isSparse()) {
                for (Long key : this.getCachedKeys()) {
                    mergedCounts.put(key);
                }
            }
            if (second.isSparse()) {
                for (Long key : second.getCachedKeys()) {
                    mergedCounts.put(key);
                }
            }
            result = new CompactIndex(this.getNumberOfFeatures(), mergedCounts, this.getNumberOfCounts() + second.getNumberOfCounts());
        }
        return result;
    }
}

