/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.db.data.ApproximateCountsUtils;
import be.bagofwords.db.data.CountsList;
import be.bagofwords.db.data.LongCountsBloomFilter;
import be.bagofwords.util.Compactable;
import be.bagofwords.util.Pair;
import org.codehaus.jackson.annotate.JsonIgnore;

public class CompactCountsIndex
implements Compactable {
    public static final double FPP = 0.01;
    private int numberOfCounts;
    private long maxCounts;
    private CountsList cachedKeys;
    private LongCountsBloomFilter filterCounts;

    public CompactCountsIndex(long maxCounts, int numberOfCounts) {
        this.maxCounts = maxCounts;
        this.numberOfCounts = numberOfCounts;
        this.cachedKeys = new CountsList();
    }

    public CompactCountsIndex(long maxCounts, LongCountsBloomFilter filterCounts, int numberOfCounts) {
        this.maxCounts = maxCounts;
        this.numberOfCounts = numberOfCounts;
        this.filterCounts = filterCounts;
    }

    public CompactCountsIndex() {
    }

    @JsonIgnore
    public boolean isSparse() {
        return this.filterCounts == null;
    }

    public void addCount(long key) {
        this.addCount(key, 1);
    }

    public void addCount(long key, int count) {
        if (this.isSparse()) {
            this.cachedKeys.addCount(key, count);
        } else {
            this.filterCounts.addCount(key, count);
        }
        this.numberOfCounts += count;
    }

    public long getMaxCounts() {
        return this.maxCounts;
    }

    public void setMaxCounts(long maxCounts) {
        this.maxCounts = maxCounts;
    }

    public CountsList getCachedKeys() {
        return this.cachedKeys;
    }

    public void setCachedKeys(CountsList cachedKeys) {
        this.cachedKeys = cachedKeys;
    }

    public LongCountsBloomFilter getFilterCounts() {
        return this.filterCounts;
    }

    public void setFilterCounts(LongCountsBloomFilter filterCounts) {
        this.filterCounts = filterCounts;
    }

    public int getNumberOfCounts() {
        return this.numberOfCounts;
    }

    public void setNumberOfCounts(int numberOfCounts) {
        this.numberOfCounts = numberOfCounts;
    }

    public int getCount(long key) {
        if (this.isSparse()) {
            return (int)this.cachedKeys.getCount(key);
        }
        return this.filterCounts.getMaxCount(key);
    }

    public void incrementNumberOfCounts() {
        ++this.numberOfCounts;
    }

    public CompactCountsIndex mergeWith(CompactCountsIndex second) {
        CompactCountsIndex result;
        boolean makeSparse;
        long maxSizeForSparse = this.getNumberOfValuesForSparse();
        boolean bl = makeSparse = this.isSparse() && second.isSparse() && (long)(this.getCachedKeys().size() + second.getCachedKeys().size()) < maxSizeForSparse;
        if (makeSparse) {
            result = new CompactCountsIndex(this.getMaxCounts(), this.getNumberOfCounts() + second.getNumberOfCounts());
            result.setCachedKeys(new CountsList(this.getCachedKeys()));
            for (Pair value : second.getCachedKeys()) {
                result.addCount((Long)value.getFirst(), ((Long)value.getSecond()).intValue());
            }
        } else {
            LongCountsBloomFilter mergedCounts = !this.isSparse() && !second.isSparse() ? ApproximateCountsUtils.mergeBloomCountFilters(this.getFilterCounts(), second.getFilterCounts()) : (!this.isSparse() ? this.getFilterCounts().clone() : (!second.isSparse() ? second.getFilterCounts().clone() : new LongCountsBloomFilter(this.getMaxCounts(), 0.01)));
            if (this.isSparse()) {
                for (Pair value : this.getCachedKeys()) {
                    mergedCounts.addCount((Long)value.getFirst(), ((Long)value.getSecond()).intValue());
                }
            }
            if (second.isSparse()) {
                for (Pair value : second.getCachedKeys()) {
                    mergedCounts.addCount((Long)value.getFirst(), ((Long)value.getSecond()).intValue());
                }
            }
            result = new CompactCountsIndex(this.getMaxCounts(), mergedCounts, this.getNumberOfCounts() + second.getNumberOfCounts());
        }
        return result;
    }

    public void compact() {
        if (this.isSparse()) {
            this.getCachedKeys().compact();
        }
    }

    @JsonIgnore
    public int getNumberOfValuesForSparse() {
        return (int)this.getMaxCounts() / 10;
    }

    @JsonIgnore
    public int getTotal() {
        return this.getNumberOfCounts();
    }

    public CompactCountsIndex clone() {
        CompactCountsIndex clone = new CompactCountsIndex(this.getMaxCounts(), this.getNumberOfCounts());
        if (this.isSparse()) {
            clone.setCachedKeys(this.getCachedKeys().clone());
        } else {
            clone.setFilterCounts(this.getFilterCounts().clone());
        }
        return clone;
    }
}

