/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.counts.BinComputer;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.bloomfilter.LongBloomFilter;
import be.bagofwords.db.data.ApproximateCountsFilter;
import be.bagofwords.db.data.LongCountsBloomFilter;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.ui.UI;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.NumUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ApproximateCountsUtils {
    public static ApproximateCountsFilter createFilterFromDataInterface(DataInterface<Long> dataInterface, double fpp) {
        int numOfValuesForBins = 10000;
        BinComputer bc = new BinComputer(numOfValuesForBins);
        CloseableIterator<KeyValue<Long>> it = dataInterface.iterator();
        while (it.hasNext() && bc.getAllValues().size() < numOfValuesForBins) {
            KeyValue next = (KeyValue)it.next();
            if ((Long)next.getValue() <= 1L) continue;
            bc.addCount((double)((Long)next.getValue()).longValue());
        }
        it.close();
        double[] binBorders = bc.getEquiDenseBins(254);
        List[] binnedValues = new List[binBorders.length + 1];
        for (int i = 0; i < binnedValues.length; ++i) {
            binnedValues[i] = new ArrayList();
        }
        Iterator i = bc.getAllValues().iterator();
        while (i.hasNext()) {
            double value = (Double)i.next();
            int bin = NumUtils.getBin((double[])binBorders, (double)value);
            binnedValues[bin].add(Math.round(value));
        }
        long[] averageValues = new long[binnedValues.length];
        for (int i2 = 0; i2 < binnedValues.length; ++i2) {
            if (!binnedValues[i2].isEmpty()) {
                double average = (double)NumUtils.sumOfLongValues((List)binnedValues[i2]) / (double)binnedValues[i2].size();
                averageValues[i2] = Math.round(average);
                continue;
            }
            averageValues[i2] = i2 > 0 ? (long)binBorders[i2 - 1] + 1L : 1L;
        }
        long[] numOfExpectedValues = ApproximateCountsUtils.countValues(dataInterface);
        LongBloomFilter oneCountsBloomFilter = new LongBloomFilter(numOfExpectedValues[0], fpp);
        LongCountsBloomFilter otherCountsBloomFilter = new LongCountsBloomFilter(numOfExpectedValues[1], fpp);
        UI.write((String)("Adding all counts to the filter with size " + otherCountsBloomFilter.getBytes().size() + "+" + oneCountsBloomFilter.getBits().size() / 8 + ". This might take a while"));
        it = dataInterface.iterator();
        while (it.hasNext()) {
            KeyValue value = (KeyValue)it.next();
            if ((Long)value.getValue() == 1L) {
                oneCountsBloomFilter.put(value.getKey());
                continue;
            }
            int bin = NumUtils.getBin((double[])binBorders, (double)((Long)value.getValue()).longValue());
            otherCountsBloomFilter.addCount(value.getKey(), bin + 1);
        }
        it.close();
        return new ApproximateCountsFilter(averageValues, oneCountsBloomFilter, otherCountsBloomFilter);
    }

    private static long[] countValues(DataInterface<Long> dataInterface) {
        long oneCounts = 0L;
        long otherCounts = 0L;
        CloseableIterator<KeyValue<Long>> it = dataInterface.iterator();
        while (it.hasNext()) {
            KeyValue value = (KeyValue)it.next();
            if ((Long)value.getValue() == 1L) {
                ++oneCounts;
                continue;
            }
            ++otherCounts;
        }
        it.close();
        return new long[]{oneCounts, otherCounts};
    }

    public static ApproximateCountsFilter createEmptyCountsFilter() {
        LongCountsBloomFilter bloomFilter = new LongCountsBloomFilter(1L, 0.1);
        long[] averages = new long[]{};
        return new ApproximateCountsFilter(averages, ApproximateCountsUtils.createEmptyBloomFilter(), bloomFilter);
    }

    public static LongBloomFilter createEmptyBloomFilter() {
        return new LongBloomFilter(1L, 0.1);
    }

    public static LongBloomFilter createTotalBloomFilter(DataInterface<Long> totalCountsDI, int minFrequency) {
        long start = System.currentTimeMillis();
        long numOfValuesToAdd = 0L;
        CloseableIterator<KeyValue<Long>> it = totalCountsDI.iterator();
        while (it.hasNext()) {
            if ((Long)((KeyValue)it.next()).getValue() < (long)minFrequency) continue;
            ++numOfValuesToAdd;
        }
        it.close();
        LongBloomFilter result = new LongBloomFilter(numOfValuesToAdd, 0.01);
        it = totalCountsDI.iterator();
        while (it.hasNext()) {
            KeyValue next = (KeyValue)it.next();
            if ((Long)next.getValue() < (long)minFrequency) continue;
            result.put(next.getKey());
        }
        it.close();
        UI.write((String)("Creating bloom filter took " + (System.currentTimeMillis() - start) + " ms for " + numOfValuesToAdd + " values, taking " + result.getBits().getData().length * 8 + " bytes"));
        return result;
    }

    public static LongBloomFilter mergeBloomFilters(LongBloomFilter first, LongBloomFilter second) {
        if (first.getNumOfHashFunctions() != second.getNumOfHashFunctions()) {
            throw new RuntimeException("Unequal number of hash functions!");
        }
        LongBloomFilter.BitArray bitArray1 = first.getBits();
        LongBloomFilter.BitArray bitArray2 = second.getBits();
        return new LongBloomFilter(bitArray1.mergeWith(bitArray2), first.getNumOfHashFunctions());
    }

    public static LongCountsBloomFilter mergeBloomCountFilters(LongCountsBloomFilter first, LongCountsBloomFilter second) {
        if (first.getNumOfHashFunctions() != second.getNumOfHashFunctions()) {
            throw new RuntimeException("Unequal number of hash functions!");
        }
        LongCountsBloomFilter.ByteArray byteArray1 = first.getBytes();
        LongCountsBloomFilter.ByteArray byteArray2 = second.getBytes();
        return new LongCountsBloomFilter(byteArray1.mergeWith(byteArray2), first.getNumOfHashFunctions());
    }
}

