/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.data;

import be.bagofwords.db.bloomfilter.LongBloomFilter;
import be.bagofwords.db.data.LongCountsBloomFilter;

public class ApproximateCountsFilter {
    private long[] averageValues;
    private LongCountsBloomFilter otherCountsBloomFilter;
    private LongBloomFilter oneCountsBloomFilter;

    public ApproximateCountsFilter(long[] averageValues, LongBloomFilter onceCountsBloomFilter, LongCountsBloomFilter otherCountsBloomFilter) {
        this.averageValues = averageValues;
        this.oneCountsBloomFilter = onceCountsBloomFilter;
        this.otherCountsBloomFilter = otherCountsBloomFilter;
    }

    public long getCount(long key) {
        int ind = this.otherCountsBloomFilter.getMaxCount(key);
        if (ind == 0) {
            if (this.oneCountsBloomFilter.mightContain(key)) {
                return 1L;
            }
            return 0L;
        }
        return this.averageValues[ind - 1];
    }

    public long[] getAverageValues() {
        return this.averageValues;
    }

    public LongCountsBloomFilter getOtherCountsBloomFilter() {
        return this.otherCountsBloomFilter;
    }

    public LongBloomFilter getOneCountsBloomFilter() {
        return this.oneCountsBloomFilter;
    }

    public ApproximateCountsFilter() {
    }

    public void setAverageValues(long[] averageValues) {
        this.averageValues = averageValues;
    }

    public void setOtherCountsBloomFilter(LongCountsBloomFilter otherCountsBloomFilter) {
        this.otherCountsBloomFilter = otherCountsBloomFilter;
    }

    public void setOneCountsBloomFilter(LongBloomFilter oneCountsBloomFilter) {
        this.oneCountsBloomFilter = oneCountsBloomFilter;
    }
}

