/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.cached;

import be.bagofwords.cache.Cache;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.LayeredDataInterface;
import be.bagofwords.util.DataLock;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.Utils;
import java.util.Iterator;
import java.util.List;

public class CachedDataInterface<T>
extends LayeredDataInterface<T> {
    private Cache<T> readCache;
    private Cache<T> writeCache;
    private final DataLock writeLock;
    private final String flushLock = new String("LOCK");
    private long timeOfLastFlush;

    public CachedDataInterface(CachesManager cachesManager, DataInterface<T> baseInterface) {
        super(baseInterface);
        this.readCache = cachesManager.createNewCache(false, this.getName() + "_read", baseInterface.getObjectClass());
        this.writeCache = cachesManager.createNewCache(true, this.getName() + "_write", baseInterface.getObjectClass());
        this.writeLock = new DataLock(10000, false);
    }

    @Override
    public T read(long key) {
        KeyValue cachedValue = this.readCache.get(key);
        if (cachedValue == null) {
            Object value = this.baseInterface.read(key);
            this.readCache.put(key, value);
            return value;
        }
        return (T)cachedValue.getValue();
    }

    @Override
    public boolean mightContain(long key) {
        KeyValue cachedValue = this.readCache.get(key);
        if (cachedValue != null) {
            return cachedValue.getValue() != null;
        }
        return this.baseInterface.mightContain(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long key, T value) {
        this.waitForSlowFlushes();
        this.writeLock.lockWrite(key);
        try {
            this.nonSynchronizedWrite(key, value);
        }
        finally {
            this.writeLock.unlockWrite(key);
        }
    }

    private void waitForSlowFlushes() {
        long now = System.currentTimeMillis();
        while (now - this.timeOfLastFlush > 5000L) {
            Utils.threadSleep((long)10L);
        }
    }

    private void nonSynchronizedWrite(long key, T value) {
        KeyValue cachedValue = this.writeCache.get(key);
        if (cachedValue == null) {
            this.writeCache.put(key, value);
        } else if (value != null && cachedValue.getValue() != null) {
            Object combinedValue = this.getCombinator().combine(cachedValue.getValue(), value);
            this.writeCache.put(key, combinedValue);
        } else {
            this.writeCache.put(key, value);
        }
    }

    @Override
    public void write(Iterator<KeyValue<T>> entries) {
        this.flushWriteCache();
        this.baseInterface.write(entries);
    }

    @Override
    public synchronized void doClose() {
        try {
            this.flush();
        }
        finally {
            this.readCache.clear();
            this.readCache = null;
            this.writeCache.clear();
            this.writeCache = null;
            this.baseInterface.close();
        }
    }

    @Override
    public void flush() {
        this.flushWriteCache();
        this.baseInterface.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWriteCache() {
        String string = this.flushLock;
        synchronized (string) {
            this.writeLock.lockWriteAll();
            List allValues = this.writeCache.removeAllValues();
            this.writeLock.unlockWriteAll();
            if (!allValues.isEmpty()) {
                this.baseInterface.write(allValues.iterator());
            }
            this.timeOfLastFlush = System.currentTimeMillis();
        }
    }

    @Override
    public void dropAllData() {
        this.writeCache.clear();
        this.readCache.clear();
        this.baseInterface.dropAllData();
    }

    @Override
    public long apprSize() {
        return this.writeCache.size() + this.baseInterface.apprSize();
    }

    @Override
    public void valuesChanged(long[] keys) {
        super.valuesChanged(keys);
        long[] lArray = keys;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long key = lArray[i];
            this.readCache.remove(key.longValue());
        }
    }
}

