/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.bloomfilter;

import be.bagofwords.util.HashUtils;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"dataCheckSum"})
public class LongBloomFilter
implements Serializable {
    private int numOfHashFunctions;
    private BitArray bits;

    public LongBloomFilter(long expectedSize, double fpp) {
        if (expectedSize > Integer.MAX_VALUE) {
            throw new RuntimeException("Creating a bloomfilter currently not supported for size " + expectedSize);
        }
        if (expectedSize == 0L) {
            expectedSize = 100L;
        }
        long numBits = LongBloomFilter.optimalNumOfBits(expectedSize, fpp);
        this.bits = new BitArray(numBits);
        this.numOfHashFunctions = LongBloomFilter.optimalNumOfHashFunctions(expectedSize, numBits);
    }

    public LongBloomFilter(BitArray bitArray, int numOfHashFunctions) {
        this.bits = bitArray;
        this.numOfHashFunctions = numOfHashFunctions;
    }

    public boolean mightContain(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        if (hash1 == 0 || hash2 == 0) {
            hash64 = HashUtils.randomDistributeHash((long)hash64);
            hash1 = (int)hash64;
            hash2 = (int)(hash64 >>> 32);
        }
        for (int i = 1; i <= this.numOfHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            if (this.bits.get(nextHash % this.bits.size())) continue;
            return false;
        }
        return true;
    }

    public <T> boolean put(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        if (hash1 == 0 || hash2 == 0) {
            hash64 = HashUtils.randomDistributeHash((long)hash64);
            hash1 = (int)hash64;
            hash2 = (int)(hash64 >>> 32);
        }
        boolean bitsChanged = false;
        for (int i = 1; i <= this.numOfHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set(nextHash % this.bits.size());
        }
        return bitsChanged;
    }

    private static long optimalNumOfBits(long n, double fpp) {
        if (fpp == 0.0) {
            fpp = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }

    private static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)(m / n) * Math.log(2.0)));
    }

    public LongBloomFilter() {
    }

    public int getNumOfHashFunctions() {
        return this.numOfHashFunctions;
    }

    public void setNumOfHashFunctions(int numOfHashFunctions) {
        this.numOfHashFunctions = numOfHashFunctions;
    }

    public double expectedFpp() {
        return Math.pow((double)this.bits.getBitCount() / (double)this.bits.size(), this.numOfHashFunctions);
    }

    public LongBloomFilter clone() {
        return new LongBloomFilter(this.getBits().clone(), this.numOfHashFunctions);
    }

    public BitArray getBits() {
        return this.bits;
    }

    public void setBits(BitArray bits) {
        this.bits = bits;
    }

    public static class BitArray {
        private long[] data;
        private int bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast((long)LongMath.divide((long)bits, (long)64L, (RoundingMode)RoundingMode.CEILING))]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"data length is zero!");
            this.data = data;
            int bitCount = 0;
            for (long value : data) {
                bitCount += Long.bitCount(value);
            }
            this.bitCount = bitCount;
        }

        public BitArray() {
        }

        public BitArray clone() {
            return new BitArray((long[])this.data.clone());
        }

        boolean set(int index) {
            if (!this.get(index)) {
                int n = index >> 6;
                this.data[n] = this.data[n] | 1L << index;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(int index) {
            return (this.data[index >> 6] & 1L << index) != 0L;
        }

        public int size() {
            return this.data.length * 64;
        }

        int getBitCount() {
            return this.bitCount;
        }

        public void setBitCount(int bitCount) {
            this.bitCount = bitCount;
        }

        public long[] getData() {
            return this.data;
        }

        public void setData(long[] data) {
            this.data = data;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }

        public BitArray mergeWith(BitArray otherBitArray) {
            if (otherBitArray.size() != this.size()) {
                throw new RuntimeException("Unequal sizes!");
            }
            BitArray result = new BitArray(this.size());
            int bitCount = 0;
            for (int i = 0; i < this.data.length; ++i) {
                result.data[i] = this.data[i] | otherBitArray.data[i];
                bitCount += Long.bitCount(result.data[i]);
            }
            result.bitCount = bitCount;
            return result;
        }
    }

    public static class LongFunnel
    implements Funnel<Long> {
        public void funnel(Long s, PrimitiveSink primitiveSink) {
            primitiveSink.putLong(s.longValue());
        }
    }
}

