/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.bloomfilter;

import be.bagofwords.db.DataInterface;
import be.bagofwords.db.LayeredDataInterface;
import be.bagofwords.db.bloomfilter.LongBloomFilterWithCheckSum;
import be.bagofwords.iterator.CloseableIterator;
import java.util.concurrent.locks.ReentrantLock;

public class BloomFilterDataInterface<T>
extends LayeredDataInterface<T> {
    private static final double INITIAL_FPP = 0.001;
    private static final double MAX_FPP = 0.02;
    private final DataInterface<LongBloomFilterWithCheckSum> bloomFilterDataInterface;
    private final ReentrantLock modifyBloomFilterLock;
    private LongBloomFilterWithCheckSum bloomFilter;
    private boolean bloomFilterWasWrittenToDisk;
    private long currentKeyForNewBloomFilterCreation = Long.MAX_VALUE;
    private long timeOfLastRead;

    public BloomFilterDataInterface(DataInterface<T> baseInterface, DataInterface<LongBloomFilterWithCheckSum> bloomFilterDataInterface) {
        super(baseInterface);
        this.bloomFilterDataInterface = bloomFilterDataInterface;
        this.modifyBloomFilterLock = new ReentrantLock();
        this.bloomFilter = bloomFilterDataInterface.read(this.getName());
    }

    @Override
    public void optimizeForReading() {
        this.baseInterface.optimizeForReading();
        if (this.bloomFilter == null) {
            this.createNewBloomFilter();
        }
    }

    @Override
    public T read(long key) {
        this.timeOfLastRead = System.currentTimeMillis();
        LongBloomFilterWithCheckSum currentBloomFilter = this.bloomFilter;
        if (currentBloomFilter == null && this.modifyBloomFilterLock.tryLock()) {
            this.createNewBloomFilter();
            currentBloomFilter = this.bloomFilter;
            this.modifyBloomFilterLock.unlock();
        }
        if (currentBloomFilter == null || this.currentKeyForNewBloomFilterCreation < key) {
            return this.baseInterface.read(key);
        }
        if (currentBloomFilter.mightContain(key)) {
            return this.baseInterface.read(key);
        }
        return null;
    }

    @Override
    public void dropAllData() {
        this.modifyBloomFilterLock.lock();
        try {
            this.baseInterface.dropAllData();
            this.createNewBloomFilterNonSynchronized();
        }
        finally {
            this.modifyBloomFilterLock.unlock();
        }
    }

    @Override
    public boolean mightContain(long key) {
        LongBloomFilterWithCheckSum currentBloomFilter = this.bloomFilter;
        if (currentBloomFilter == null && this.modifyBloomFilterLock.tryLock()) {
            this.createNewBloomFilter();
            currentBloomFilter = this.bloomFilter;
            this.modifyBloomFilterLock.unlock();
        }
        if (currentBloomFilter == null || this.currentKeyForNewBloomFilterCreation < key) {
            return this.baseInterface.mightContain(key);
        }
        return currentBloomFilter.mightContain(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valuesChanged(long[] keys) {
        super.valuesChanged(keys);
        this.modifyBloomFilterLock.lock();
        try {
            if (this.bloomFilter != null) {
                long[] lArray = keys;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long key = lArray[i];
                    this.bloomFilter.put(key);
                }
                if (this.bloomFilter.expectedFpp() > 0.02) {
                    if (System.currentTimeMillis() - this.timeOfLastRead < 1000L) {
                        this.createNewBloomFilterNonSynchronized();
                    } else {
                        this.bloomFilter = null;
                    }
                }
            }
            if (keys.length > 0) {
                this.bloomFilterWasWrittenToDisk = false;
            }
        }
        finally {
            this.modifyBloomFilterLock.unlock();
        }
    }

    private void createNewBloomFilterNonSynchronized() {
        this.currentKeyForNewBloomFilterCreation = Long.MIN_VALUE;
        long numOfValuesForBloomFilter = Math.max(1000000L, this.baseInterface.apprSize());
        this.bloomFilter = new LongBloomFilterWithCheckSum(numOfValuesForBloomFilter, 0.001);
        this.bloomFilter.setDataCheckSum(this.baseInterface.dataCheckSum());
        long start = System.currentTimeMillis();
        int numOfKeys = 0;
        CloseableIterator<Long> it = this.baseInterface.keyIterator();
        while (it.hasNext()) {
            long key = (Long)it.next();
            this.bloomFilter.put(key);
            ++numOfKeys;
            this.currentKeyForNewBloomFilterCreation = key;
        }
        it.close();
        this.currentKeyForNewBloomFilterCreation = Long.MAX_VALUE;
        long taken = System.currentTimeMillis() - start;
    }

    private void createNewBloomFilter() {
        this.modifyBloomFilterLock.lock();
        this.createNewBloomFilterNonSynchronized();
        this.modifyBloomFilterLock.unlock();
    }

    @Override
    public void flush() {
        this.baseInterface.flush();
        if (!this.bloomFilterWasWrittenToDisk) {
            this.bloomFilterDataInterface.write(this.getName(), this.bloomFilter);
            this.bloomFilterWasWrittenToDisk = true;
        }
    }

    @Override
    protected void doClose() {
        this.bloomFilter = null;
    }
}

