/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db.application;

import be.bagofwords.application.BaseApplicationContextFactory;
import be.bagofwords.db.application.environment.FileCountDBEnvironmentProperties;
import be.bagofwords.db.filedb.FileDataInterfaceFactory;
import be.bagofwords.virtualfile.local.LocalFileService;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class EmbeddedDBContextFactory
extends BaseApplicationContextFactory {
    private String dataDirectory;

    public EmbeddedDBContextFactory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public AnnotationConfigApplicationContext createApplicationContext() {
        this.scan("be.bagofwords");
        this.singleton("environmentProperties", new FileCountDBEnvironmentProperties(){

            public boolean saveThreadSamplesToFile() {
                return false;
            }

            public String getThreadSampleLocation() {
                return "./perf";
            }

            public String getApplicationUrlRoot() {
                return "localhost";
            }

            @Override
            public String getDataDirectory() {
                return EmbeddedDBContextFactory.this.dataDirectory;
            }
        });
        this.bean(FileDataInterfaceFactory.class);
        this.bean(LocalFileService.class);
        return super.createApplicationContext();
    }
}

