/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db;

import be.bagofwords.db.DataInterface;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.util.KeyValue;
import java.util.Iterator;

public abstract class LayeredDataInterface<T>
extends DataInterface<T> {
    protected DataInterface<T> baseInterface;

    public LayeredDataInterface(DataInterface<T> baseInterface) {
        super(baseInterface.getName(), baseInterface.getObjectClass(), baseInterface.getCombinator());
        this.baseInterface = baseInterface;
        this.baseInterface.registerListener(this);
    }

    @Override
    public T read(long key) {
        return this.baseInterface.read(key);
    }

    @Override
    public void write(long key, T value) {
        this.baseInterface.write(key, value);
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator() {
        return this.baseInterface.iterator();
    }

    @Override
    public void dropAllData() {
        this.baseInterface.dropAllData();
    }

    @Override
    public void flush() {
        this.baseInterface.flush();
    }

    @Override
    public void optimizeForReading() {
        this.flush();
        this.baseInterface.optimizeForReading();
    }

    @Override
    public DataInterface getImplementingDataInterface() {
        return this.baseInterface;
    }

    @Override
    public long apprSize() {
        return this.baseInterface.apprSize();
    }

    @Override
    public void write(Iterator<KeyValue<T>> entries) {
        this.baseInterface.write(entries);
    }

    @Override
    public CloseableIterator<KeyValue<T>> iterator(Iterator<Long> keyIterator) {
        return this.baseInterface.iterator(keyIterator);
    }

    @Override
    public CloseableIterator<Long> keyIterator() {
        return this.baseInterface.keyIterator();
    }

    @Override
    public CloseableIterator<T> valueIterator() {
        return this.baseInterface.valueIterator();
    }

    @Override
    public boolean mightContain(long key) {
        return this.baseInterface.mightContain(key);
    }

    @Override
    public void valuesChanged(long[] keys) {
        this.notifyListenersOfChangedValues(keys);
    }

    @Override
    public void close() {
        if (!this.wasClosed()) {
            try {
                this.doClose();
            }
            finally {
                this.baseInterface.close();
            }
        }
    }

    @Override
    public boolean wasClosed() {
        return this.baseInterface.wasClosed();
    }

    protected abstract void doClose();
}

