/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db;

import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.application.memory.MemoryStatus;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DataInterfaceFactory;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class FlushDataInterfacesThread
extends SafeThread {
    public static final long TIME_BETWEEN_FLUSHES = 1000L;
    private final DataInterfaceFactory dataInterfaceFactory;
    private final MemoryManager memoryManager;

    public FlushDataInterfacesThread(DataInterfaceFactory dataInterfaceFactory, MemoryManager memoryManager) {
        super("FlushWriteBuffer", true);
        this.dataInterfaceFactory = dataInterfaceFactory;
        this.memoryManager = memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInt() {
        while (!this.isTerminateRequested()) {
            long actualTimeToSleep;
            ArrayList<DataInterface> currentInterfaces;
            long timeBeforeFlush = System.currentTimeMillis();
            List<DataInterface> list = this.dataInterfaceFactory.getAllInterfaces();
            synchronized (list) {
                currentInterfaces = new ArrayList<DataInterface>(this.dataInterfaceFactory.getAllInterfaces());
            }
            for (DataInterface dataInterface : currentInterfaces) {
                try {
                    dataInterface.flushIfNotClosed();
                }
                catch (Throwable t) {
                    UI.writeError((String)("Received exception while flushing write buffer for data interface " + dataInterface.getName() + ". Will close this interface."), (Throwable)t);
                    try {
                        dataInterface.close();
                    }
                    catch (Throwable t2) {
                        UI.writeError((String)("Failed to close " + dataInterface.getName()), (Throwable)t2);
                    }
                }
            }
            long timeToSleepBetweenFlushes = 1000L;
            if (this.memoryManager.getMemoryStatus() == MemoryStatus.CRITICAL) {
                timeToSleepBetweenFlushes = 0L;
            }
            if ((actualTimeToSleep = timeBeforeFlush - System.currentTimeMillis() + timeToSleepBetweenFlushes) <= 0L) continue;
            Utils.threadSleep((long)actualTimeToSleep);
        }
    }
}

