/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db;

import be.bagofwords.application.LateCloseableComponent;
import be.bagofwords.application.memory.MemoryManager;
import be.bagofwords.cache.CachesManager;
import be.bagofwords.db.DataInterface;
import be.bagofwords.db.DatabaseCachingType;
import be.bagofwords.db.FlushDataInterfacesThread;
import be.bagofwords.db.bloomfilter.BloomFilterDataInterface;
import be.bagofwords.db.bloomfilter.LongBloomFilterWithCheckSum;
import be.bagofwords.db.cached.CachedDataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.db.combinator.LongCombinator;
import be.bagofwords.db.combinator.OverWriteCombinator;
import java.util.ArrayList;
import java.util.List;

public abstract class DataInterfaceFactory
implements LateCloseableComponent {
    private final CachesManager cachesManager;
    private final List<DataInterface> allInterfaces;
    private DataInterface<LongBloomFilterWithCheckSum> cachedBloomFilters;
    private FlushDataInterfacesThread flushDataInterfacesThread;

    public DataInterfaceFactory(CachesManager cachesManager, MemoryManager memoryManager) {
        this.cachesManager = cachesManager;
        this.allInterfaces = new ArrayList<DataInterface>();
        this.flushDataInterfacesThread = new FlushDataInterfacesThread(this, memoryManager);
        this.flushDataInterfacesThread.start();
    }

    protected abstract <T> DataInterface<T> createBaseDataInterface(String var1, Class<T> var2, Combinator<T> var3);

    public DataInterface<Long> createCountDataInterface(String subset) {
        return this.createDataInterface(DatabaseCachingType.CACHED_AND_BLOOM, subset, Long.class, new LongCombinator());
    }

    public <T> DataInterface<T> createDataInterface(DatabaseCachingType type, String subset, Class<T> objectClass) {
        return this.createDataInterface(type, subset, objectClass, new OverWriteCombinator());
    }

    public <T> DataInterface<T> createDataInterface(String subset, Class<T> objectClass) {
        return this.createDataInterface(DatabaseCachingType.CACHED_AND_BLOOM, subset, objectClass, new OverWriteCombinator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DataInterface<T> createDataInterface(DatabaseCachingType type, String subset, Class<T> objectClass, Combinator<T> combinator) {
        DataInterface<T> result = this.createBaseDataInterface(subset, objectClass, combinator);
        if (type.useCache()) {
            result = this.cached(result);
        }
        if (type.useBloomFilter()) {
            result = this.bloom(result);
        }
        List<DataInterface> list = this.allInterfaces;
        synchronized (list) {
            this.allInterfaces.add(result);
        }
        return result;
    }

    protected <T> DataInterface<T> cached(DataInterface<T> baseDataInterface) {
        return new CachedDataInterface<T>(this.cachesManager, baseDataInterface);
    }

    protected <T> DataInterface<T> bloom(DataInterface<T> dataInterface) {
        this.checkInitialisationCachedBloomFilters();
        return new BloomFilterDataInterface<T>(dataInterface, this.cachedBloomFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialisationCachedBloomFilters() {
        if (this.cachedBloomFilters == null) {
            this.cachedBloomFilters = this.createBaseDataInterface("system/bloomFilter", LongBloomFilterWithCheckSum.class, new OverWriteCombinator());
            List<DataInterface> list = this.allInterfaces;
            synchronized (list) {
                this.allInterfaces.add(this.cachedBloomFilters);
            }
        }
    }

    public List<DataInterface> getAllInterfaces() {
        return this.allInterfaces;
    }

    public synchronized void terminate() {
        this.flushDataInterfacesThread.terminateAndWaitForFinish();
        this.closeAllInterfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllInterfaces() {
        List<DataInterface> list = this.allInterfaces;
        synchronized (list) {
            for (DataInterface dataI : this.allInterfaces) {
                if (dataI == this.cachedBloomFilters) continue;
                dataI.flushIfNotClosed();
                dataI.close();
            }
            if (this.cachedBloomFilters != null) {
                this.cachedBloomFilters.flushIfNotClosed();
                this.cachedBloomFilters.close();
                this.cachedBloomFilters = null;
            }
            this.allInterfaces.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

