/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db;

import be.bagofwords.db.ChangedValuesListener;
import be.bagofwords.db.ChangedValuesPublisher;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.iterator.CloseableIterator;
import be.bagofwords.iterator.DataIterable;
import be.bagofwords.iterator.IterableUtils;
import be.bagofwords.iterator.SimpleIterator;
import be.bagofwords.text.SimpleString;
import be.bagofwords.util.HashUtils;
import be.bagofwords.util.KeyValue;
import be.bagofwords.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DataInterface<T>
implements DataIterable<KeyValue<T>>,
ChangedValuesPublisher,
ChangedValuesListener {
    private final Combinator<T> combinator;
    private final Class<T> objectClass;
    private final String name;
    private final List<ChangedValuesListener> listeners;

    protected DataInterface(String name, Class<T> objectClass, Combinator<T> combinator) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name can not be null or empty");
        }
        this.name = name;
        this.objectClass = objectClass;
        this.combinator = combinator;
        this.listeners = new ArrayList<ChangedValuesListener>();
    }

    public abstract T read(long var1);

    public T read(String key) {
        return this.read(HashUtils.hashCode((String)key));
    }

    public T read(SimpleString key) {
        return this.read(HashUtils.hashCode((SimpleString)key));
    }

    public long readCount(long key) {
        Long result = (Long)this.read(key);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public long readCount(SimpleString key) {
        return this.readCount(HashUtils.hashCode((SimpleString)key));
    }

    public long readCount(String key) {
        return this.readCount(HashUtils.hashCode((String)key));
    }

    public boolean mightContain(String key) {
        return this.mightContain(HashUtils.hashCode((String)key));
    }

    public boolean mightContain(long key) {
        return this.read(key) != null;
    }

    public abstract CloseableIterator<KeyValue<T>> iterator();

    public CloseableIterator<Long> keyIterator() {
        final CloseableIterator<KeyValue<T>> keyValueIterator = this.iterator();
        return new CloseableIterator<Long>(){

            public boolean hasNext() {
                return keyValueIterator.hasNext();
            }

            public Long next() {
                return ((KeyValue)keyValueIterator.next()).getKey();
            }

            public void closeInt() {
                keyValueIterator.close();
            }
        };
    }

    public CloseableIterator<T> valueIterator() {
        final CloseableIterator<KeyValue<T>> keyValueIterator = this.iterator();
        return new CloseableIterator<T>(){

            public boolean hasNext() {
                return keyValueIterator.hasNext();
            }

            public T next() {
                return ((KeyValue)keyValueIterator.next()).getValue();
            }

            public void closeInt() {
                keyValueIterator.close();
            }
        };
    }

    public CloseableIterator<KeyValue<T>> iterator(final Iterator<Long> keyIterator) {
        return IterableUtils.iterator((SimpleIterator)new SimpleIterator<KeyValue<T>>(){

            public KeyValue<T> next() throws Exception {
                while (keyIterator.hasNext()) {
                    Long next = (Long)keyIterator.next();
                    Object value = DataInterface.this.read(next);
                    if (value == null) continue;
                    return new KeyValue(next.longValue(), value);
                }
                return null;
            }
        });
    }

    public abstract void optimizeForReading();

    public abstract void dropAllData();

    public abstract void flush();

    public abstract long apprSize();

    public Combinator<T> getCombinator() {
        return this.combinator;
    }

    protected abstract DataInterface getImplementingDataInterface();

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public void write(SimpleString key, T value) {
        this.write(HashUtils.hashCode((String)key.getS()), value);
    }

    public void write(String key, T value) {
        this.write(HashUtils.hashCode((String)key), value);
    }

    public abstract void write(long var1, T var3);

    public void increaseCount(String key, Long value) {
        this.write(key, value);
    }

    public void increaseCount(long key, Long value) {
        this.write(key, value);
    }

    public void increaseCount(String key) {
        this.increaseCount(key, (Long)1L);
    }

    public void increaseCount(long key) {
        this.increaseCount(key, (Long)1L);
    }

    public String getName() {
        return this.name;
    }

    public void remove(String key) {
        this.remove(HashUtils.hashCode((String)key));
    }

    public void remove(long key) {
        this.write(key, null);
    }

    public long dataCheckSum() {
        CloseableIterator<KeyValue<T>> valueIterator = this.iterator();
        int numToSample = 10000;
        long checksum = 0L;
        for (int numDone = 0; valueIterator.hasNext() && numDone < 10000; ++numDone) {
            KeyValue next = (KeyValue)valueIterator.next();
            if (next.getValue() == null) {
                throw new RuntimeException("Iterating over values returned null for key " + next.getKey());
            }
            Object value = next.getValue();
            checksum += checksum * 31L + (long)value.hashCode();
        }
        valueIterator.close();
        return checksum;
    }

    public long exactSize() {
        long result = 0L;
        CloseableIterator<Long> keyIt = this.keyIterator();
        while (keyIt.hasNext()) {
            keyIt.next();
            ++result;
        }
        keyIt.close();
        return result;
    }

    public void write(Iterator<KeyValue<T>> entries) {
        while (entries.hasNext()) {
            KeyValue<T> entry = entries.next();
            this.write(entry.getKey(), entry.getValue());
        }
    }

    public abstract void close();

    public abstract boolean wasClosed();

    @Override
    public synchronized void registerListener(ChangedValuesListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChangedValues(long[] keys) {
        for (ChangedValuesListener listener : this.listeners) {
            listener.valuesChanged(keys);
        }
    }

    public synchronized void flushIfNotClosed() {
        if (!this.wasClosed()) {
            this.flush();
        }
    }
}

