/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.db;

import be.bagofwords.db.DataInterface;
import be.bagofwords.db.combinator.Combinator;
import be.bagofwords.util.KeyValue;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class CoreDataInterface<T>
extends DataInterface<T> {
    private boolean wasClosed = false;

    public CoreDataInterface(String name, Class<T> objectClass, Combinator<T> combinator) {
        super(name, objectClass, combinator);
    }

    @Override
    public void valuesChanged(long[] keys) {
        throw new RuntimeException("This method should not be called for core datainterface " + this.getClass());
    }

    @Override
    public void write(long key, T value) {
        this.writeInt0(key, value);
        this.notifyListenersOfChangedValues(new long[]{key});
    }

    @Override
    public void write(final Iterator<KeyValue<T>> entries) {
        final ArrayList keys = new ArrayList();
        this.writeInt0(new Iterator<KeyValue<T>>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public KeyValue<T> next() {
                KeyValue result = (KeyValue)entries.next();
                keys.add(result.getKey());
                return result;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not supported");
            }
        });
        long[] keysAsArray = new long[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            keysAsArray[i] = (Long)keys.get(i);
        }
        this.notifyListenersOfChangedValues(keysAsArray);
    }

    protected abstract void writeInt0(Iterator<KeyValue<T>> var1);

    protected abstract void writeInt0(long var1, T var3);

    @Override
    protected DataInterface getImplementingDataInterface() {
        return null;
    }

    @Override
    public boolean wasClosed() {
        return this.wasClosed;
    }

    @Override
    public void close() {
        if (!this.wasClosed()) {
            this.doClose();
            this.wasClosed = true;
        }
    }

    protected abstract void doClose();
}

