package be.bagofwords.text;

import java.util.HashMap;
import java.util.regex.Pattern;

public class HTMLEntities {

    public static final Pattern htmlEntityPattern = Pattern.compile("&[^&;]{2,8};");

    public static final HashMap<String, Character> entityMapping;
    public static final HashMap<Character, String> inverseEntityMapping;

    static {
        HashMap<String, Integer> tmpmap = new HashMap<>();
        tmpmap.put("&quot;", (int) '"');
        tmpmap.put("&lt;", (int) '<');
        tmpmap.put("&gt;", (int) '>');
        tmpmap.put("&Aacute;", 193);
        tmpmap.put("&aacute;", 225);
        tmpmap.put("&Acirc;", 194);
        tmpmap.put("&acirc;", 226);
        tmpmap.put("&acute;", 180);
        tmpmap.put("&AElig;", 198);
        tmpmap.put("&aelig;", 230);
        tmpmap.put("&Agrave;", 192);
        tmpmap.put("&agrave;", 224);
        tmpmap.put("&alefsym;", 8501);
        tmpmap.put("&Alpha;", 913);
        tmpmap.put("&alpha;", 945);
        tmpmap.put("&amp;", 38);
        tmpmap.put("&and;", 8743);
        tmpmap.put("&ang;", 8736);
        tmpmap.put("&Aring;", 197);
        tmpmap.put("&aring;", 229);
        tmpmap.put("&asymp;", 8776);
        tmpmap.put("&Atilde;", 195);
        tmpmap.put("&atilde;", 227);
        tmpmap.put("&Auml;", 196);
        tmpmap.put("&auml;", 228);
        tmpmap.put("&bdquo;", 8222);
        tmpmap.put("&Beta;", 914);
        tmpmap.put("&beta;", 946);
        tmpmap.put("&brvbar;", 166);
        tmpmap.put("&bull;", 8226);
        tmpmap.put("&cap;", 8745);
        tmpmap.put("&Ccedil;", 199);
        tmpmap.put("&ccedil;", 231);
        tmpmap.put("&cedil;", 184);
        tmpmap.put("&cent;", 162);
        tmpmap.put("&Chi;", 935);
        tmpmap.put("&chi;", 967);
        tmpmap.put("&circ;", 710);
        tmpmap.put("&clubs;", 9827);
        tmpmap.put("&cong;", 8773);
        tmpmap.put("&copy;", 169);
        tmpmap.put("&crarr;", 8629);
        tmpmap.put("&cup;", 8746);
        tmpmap.put("&curren;", 164);
        tmpmap.put("&dagger;", 8224);
        tmpmap.put("&Dagger;", 8225);
        tmpmap.put("&darr;", 8595);
        tmpmap.put("&dArr;", 8659);
        tmpmap.put("&deg;", 176);
        tmpmap.put("&Delta;", 916);
        tmpmap.put("&delta;", 948);
        tmpmap.put("&diams;", 9830);
        tmpmap.put("&divide;", 247);
        tmpmap.put("&Eacute;", 201);
        tmpmap.put("&eacute;", 233);
        tmpmap.put("&Ecirc;", 202);
        tmpmap.put("&ecirc;", 234);
        tmpmap.put("&Egrave;", 200);
        tmpmap.put("&egrave;", 232);
        tmpmap.put("&empty;", 8709);
        tmpmap.put("&emsp;", 8195);
        tmpmap.put("&ensp;", 8194);
        tmpmap.put("&Epsilon;", 917);
        tmpmap.put("&epsilon;", 949);
        tmpmap.put("&equiv;", 8801);
        tmpmap.put("&Eta;", 919);
        tmpmap.put("&eta;", 951);
        tmpmap.put("&ETH;", 208);
        tmpmap.put("&eth;", 240);
        tmpmap.put("&Euml;", 203);
        tmpmap.put("&euml;", 235);
        tmpmap.put("&euro;", 8364);
        tmpmap.put("&exist;", 8707);
        tmpmap.put("&fnof;", 402);
        tmpmap.put("&forall;", 8704);
        tmpmap.put("&frac12;", 189);
        tmpmap.put("&frac14;", 188);
        tmpmap.put("&frac34;", 190);
        tmpmap.put("&frasl;", 8260);
        tmpmap.put("&Gamma;", 915);
        tmpmap.put("&gamma;", 947);
        tmpmap.put("&ge;", 8805);
        tmpmap.put("&harr;", 8596);
        tmpmap.put("&hArr;", 8660);
        tmpmap.put("&hearts;", 9829);
        tmpmap.put("&hellip;", 8230);
        tmpmap.put("&Iacute;", 205);
        tmpmap.put("&iacute;", 237);
        tmpmap.put("&Icirc;", 206);
        tmpmap.put("&icirc;", 238);
        tmpmap.put("&iexcl;", 161);
        tmpmap.put("&Igrave;", 204);
        tmpmap.put("&igrave;", 236);
        tmpmap.put("&image;", 8465);
        tmpmap.put("&infin;", 8734);
        tmpmap.put("&int;", 8747);
        tmpmap.put("&Iota;", 921);
        tmpmap.put("&iota;", 953);
        tmpmap.put("&iquest;", 191);
        tmpmap.put("&isin;", 8712);
        tmpmap.put("&Iuml;", 207);
        tmpmap.put("&iuml;", 239);
        tmpmap.put("&Kappa;", 922);
        tmpmap.put("&kappa;", 954);
        tmpmap.put("&Lambda;", 923);
        tmpmap.put("&lambda;", 955);
        tmpmap.put("&lang;", 9001);
        tmpmap.put("&laquo;", 171);
        tmpmap.put("&larr;", 8592);
        tmpmap.put("&lArr;", 8656);
        tmpmap.put("&lceil;", 8968);
        tmpmap.put("&ldquo;", 8220);
        tmpmap.put("&le;", 8804);
        tmpmap.put("&lfloor;", 8970);
        tmpmap.put("&lowast;", 8727);
        tmpmap.put("&loz;", 9674);
        tmpmap.put("&lrm;", 8206);
        tmpmap.put("&lsaquo;", 8249);
        tmpmap.put("&lsquo;", 8216);
        tmpmap.put("&macr;", 175);
        tmpmap.put("&mdash;", 8212);
        tmpmap.put("&micro;", 181);
        tmpmap.put("&middot;", 183);
        tmpmap.put("&minus;", 8722);
        tmpmap.put("&Mu;", 924);
        tmpmap.put("&mu;", 956);
        tmpmap.put("&nabla;", 8711);
        tmpmap.put("&nbsp;", 160);
        tmpmap.put("&ndash;", 8211);
        tmpmap.put("&ne;", 8800);
        tmpmap.put("&ni;", 8715);
        tmpmap.put("&not;", 172);
        tmpmap.put("&notin;", 8713);
        tmpmap.put("&nsub;", 8836);
        tmpmap.put("&Ntilde;", 209);
        tmpmap.put("&ntilde;", 241);
        tmpmap.put("&Nu;", 925);
        tmpmap.put("&nu;", 957);
        tmpmap.put("&Oacute;", 211);
        tmpmap.put("&oacute;", 243);
        tmpmap.put("&Ocirc;", 212);
        tmpmap.put("&ocirc;", 244);
        tmpmap.put("&OElig;", 338);
        tmpmap.put("&oelig;", 339);
        tmpmap.put("&Ograve;", 210);
        tmpmap.put("&ograve;", 242);
        tmpmap.put("&oline;", 8254);
        tmpmap.put("&Omega;", 937);
        tmpmap.put("&omega;", 969);
        tmpmap.put("&Omicron;", 927);
        tmpmap.put("&omicron;", 959);
        tmpmap.put("&oplus;", 8853);
        tmpmap.put("&or;", 8744);
        tmpmap.put("&ordf;", 170);
        tmpmap.put("&ordm;", 186);
        tmpmap.put("&Oslash;", 216);
        tmpmap.put("&oslash;", 248);
        tmpmap.put("&Otilde;", 213);
        tmpmap.put("&otilde;", 245);
        tmpmap.put("&otimes;", 8855);
        tmpmap.put("&Ouml;", 214);
        tmpmap.put("&ouml;", 246);
        tmpmap.put("&para;", 182);
        tmpmap.put("&part;", 8706);
        tmpmap.put("&permil;", 8240);
        tmpmap.put("&perp;", 8869);
        tmpmap.put("&Phi;", 934);
        tmpmap.put("&phi;", 966);
        tmpmap.put("&Pi;", 928);
        tmpmap.put("&pi;", 960);
        tmpmap.put("&piv;", 982);
        tmpmap.put("&plusmn;", 177);
        tmpmap.put("&pound;", 163);
        tmpmap.put("&prime;", 8242);
        tmpmap.put("&Prime;", 8243);
        tmpmap.put("&prod;", 8719);
        tmpmap.put("&prop;", 8733);
        tmpmap.put("&Psi;", 936);
        tmpmap.put("&psi;", 968);
        tmpmap.put("&radic;", 8730);
        tmpmap.put("&rang;", 9002);
        tmpmap.put("&raquo;", 187);
        tmpmap.put("&rarr;", 8594);
        tmpmap.put("&rArr;", 8658);
        tmpmap.put("&rceil;", 8969);
        tmpmap.put("&rdquo;", 8221);
        tmpmap.put("&real;", 8476);
        tmpmap.put("&reg;", 174);
        tmpmap.put("&rfloor;", 8971);
        tmpmap.put("&Rho;", 929);
        tmpmap.put("&rho;", 961);
        tmpmap.put("&rlm;", 8207);
        tmpmap.put("&rsaquo;", 8250);
        tmpmap.put("&rsquo;", 8217);
        tmpmap.put("&sbquo;", 8218);
        tmpmap.put("&Scaron;", 352);
        tmpmap.put("&scaron;", 353);
        tmpmap.put("&sdot;", 8901);
        tmpmap.put("&sect;", 167);
        tmpmap.put("&shy;", 173);
        tmpmap.put("&Sigma;", 931);
        tmpmap.put("&sigma;", 963);
        tmpmap.put("&sigmaf;", 962);
        tmpmap.put("&sim;", 8764);
        tmpmap.put("&spades;", 9824);
        tmpmap.put("&sub;", 8834);
        tmpmap.put("&sube;", 8838);
        tmpmap.put("&sum;", 8721);
        tmpmap.put("&sup1;", 185);
        tmpmap.put("&sup2;", 178);
        tmpmap.put("&sup3;", 179);
        tmpmap.put("&sup;", 8835);
        tmpmap.put("&supe;", 8839);
        tmpmap.put("&szlig;", 223);
        tmpmap.put("&Tau;", 932);
        tmpmap.put("&tau;", 964);
        tmpmap.put("&there4;", 8756);
        tmpmap.put("&Theta;", 920);
        tmpmap.put("&theta;", 952);
        tmpmap.put("&thetasym;", 977);
        tmpmap.put("&thinsp;", 8201);
        tmpmap.put("&THORN;", 222);
        tmpmap.put("&thorn;", 254);
        tmpmap.put("&tilde;", 732);
        tmpmap.put("&times;", 215);
        tmpmap.put("&trade;", 8482);
        tmpmap.put("&Uacute;", 218);
        tmpmap.put("&uacute;", 250);
        tmpmap.put("&uarr;", 8593);
        tmpmap.put("&uArr;", 8657);
        tmpmap.put("&Ucirc;", 219);
        tmpmap.put("&ucirc;", 251);
        tmpmap.put("&Ugrave;", 217);
        tmpmap.put("&ugrave;", 249);
        tmpmap.put("&uml;", 168);
        tmpmap.put("&upsih;", 978);
        tmpmap.put("&Upsilon;", 933);
        tmpmap.put("&upsilon;", 965);
        tmpmap.put("&Uuml;", 220);
        tmpmap.put("&uuml;", 252);
        tmpmap.put("&weierp;", 8472);
        tmpmap.put("&Xi;", 926);
        tmpmap.put("&xi;", 958);
        tmpmap.put("&Yacute;", 221);
        tmpmap.put("&yacute;", 253);
        tmpmap.put("&yen;", 165);
        tmpmap.put("&yuml;", 255);
        tmpmap.put("&Yuml;", 376);
        tmpmap.put("&Zeta;", 918);
        tmpmap.put("&zeta;", 950);
        tmpmap.put("&zwj;", 8205);
        tmpmap.put("&zwnj;", 8204);
        entityMapping = new HashMap<>();
        inverseEntityMapping = new HashMap<>();
        for (String key : tmpmap.keySet()) {
            int character = tmpmap.get(key);
            entityMapping.put(key, (char) character);
            inverseEntityMapping.put((char) character, key);
        }
    }
}
