/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.web;

import be.bagofwords.application.CloseableComponent;
import be.bagofwords.ui.UI;
import be.bagofwords.util.SafeThread;
import be.bagofwords.util.SpringUtils;
import be.bagofwords.web.BaseController;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import spark.route.RouteMatcher;
import spark.route.RouteMatcherFactory;
import spark.webserver.SparkServer;
import spark.webserver.SparkServerFactory;

public class WebContainer
implements CloseableComponent {
    @Autowired
    private ApplicationContext applicationContext;
    private RouteMatcher routeMatcher = RouteMatcherFactory.get();
    private SparkServerThread sparkServerThread;
    private int port;

    public WebContainer(int port) {
        this.port = port;
    }

    @PostConstruct
    public void initialize() {
        this.registerControllers();
        this.sparkServerThread = new SparkServerThread(this.port);
        this.sparkServerThread.start();
    }

    @Override
    public void close() {
        this.routeMatcher.clearRoutes();
        this.sparkServerThread.terminateAndWait();
    }

    private void registerControllers() {
        List<BaseController> controllers = SpringUtils.getInstantiatedBeans(this.applicationContext, BaseController.class);
        UI.write("Found " + controllers.size() + " controllers");
        for (BaseController controller : controllers) {
            this.registerController(controller);
        }
    }

    public void registerController(BaseController controller) {
        this.routeMatcher.parseValidateAddRoute("GET '" + controller.getPath() + "'", controller.getAcceptType(), (Object)controller);
        this.routeMatcher.parseValidateAddRoute("POST '" + controller.getPath() + "'", controller.getAcceptType(), (Object)controller);
    }

    public int getPort() {
        return this.port;
    }

    private static class SparkServerThread
    extends SafeThread {
        private int port;
        private SparkServer server;

        private SparkServerThread(int port) {
            super("SparkServerThread", true);
            this.port = port;
        }

        @Override
        protected void runInt() throws Exception {
            try {
                this.server = SparkServerFactory.create((boolean)false);
                this.server.ignite("0.0.0.0", this.port, null, null, null, null, null, null);
            }
            catch (Exception exp) {
                UI.writeError("Error while trying to start spark server on port " + this.port);
                this.server = null;
            }
        }

        @Override
        protected void doTerminate() {
            if (this.server != null) {
                this.server.stop();
            }
        }
    }
}

