/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.util.Compactable;
import be.bagofwords.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.JavaType;
import org.xerial.snappy.Snappy;

public class SerializationUtils {
    public static final long LONG_NULL = 0x7FFFFFFFFFFFFFFCL;
    public static final double DOUBLE_NULL = Double.MAX_VALUE;
    public static final int INT_NULL = Integer.MAX_VALUE;
    public static final float FLOAT_NULL = Float.MAX_VALUE;
    public static final String STRING_NULL = "xyNUlLxy";
    private static final String ENCODING = "UTF-8";
    private static final ObjectMapper prettyPrintObjectMapper = new ObjectMapper();
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();

    public static String serializeObject(Object object) {
        return SerializationUtils.serializeObject(object, false);
    }

    public static String serializeObject(Object object, boolean prettyPrint) {
        try {
            if (object instanceof Compactable) {
                ((Compactable)object).compact();
            }
            ObjectMapper objectMapper = prettyPrint ? prettyPrintObjectMapper : defaultObjectMapper;
            return objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserializeObject(String object, Class<T> objectClass, Class ... genericParams) {
        try {
            if (genericParams.length > 0) {
                JavaType type = defaultObjectMapper.getTypeFactory().constructParametricType(objectClass, genericParams);
                return (T)defaultObjectMapper.readValue(object, type);
            }
            return (T)defaultObjectMapper.readValue(object, objectClass);
        }
        catch (IOException e) {
            String objectForMessage = object;
            if (!StringUtils.isEmpty((CharSequence)objectForMessage) && objectForMessage.length() > 200) {
                objectForMessage = objectForMessage.substring(0, 200) + "...";
            }
            throw new RuntimeException("Failed to read " + objectForMessage, e);
        }
    }

    public static String bytesToString(byte[] key) {
        try {
            return new String(key, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] stringToBytes(String key) {
        try {
            return key.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new RuntimeException("OOM while trying to convert " + key.substring(0, Math.min(100, key.length())) + " of length " + key.length(), outOfMemoryError);
        }
    }

    public static <T> T bytesToObject(byte[] bytes, Class<T> objectClass) {
        if (bytes == null) {
            return null;
        }
        if (objectClass == Long.class) {
            return (T)new Long(SerializationUtils.bytesToLong(bytes));
        }
        if (objectClass == Double.class) {
            return (T)new Double(Double.longBitsToDouble(SerializationUtils.bytesToLong(bytes)));
        }
        if (objectClass == Integer.class) {
            return (T)new Integer(SerializationUtils.bytesToInt(bytes));
        }
        if (objectClass == Float.class) {
            return (T)new Float(Float.intBitsToFloat(SerializationUtils.bytesToInt(bytes)));
        }
        if (objectClass == String.class) {
            return (T)SerializationUtils.bytesToString(bytes);
        }
        String objectAsString = SerializationUtils.bytesToString(bytes);
        return SerializationUtils.deserializeObject(objectAsString, objectClass, new Class[0]);
    }

    public static <T> byte[] objectToBytesCheckForNull(T value, Class<T> objectClass) {
        if (objectClass == Long.class) {
            if (value == null) {
                return SerializationUtils.longToBytes(0x7FFFFFFFFFFFFFFCL);
            }
            if (value.equals(0x7FFFFFFFFFFFFFFCL)) {
                throw new RuntimeException("Sorry " + value + " is a reserved value to indicate null.");
            }
            return SerializationUtils.longToBytes((Long)value);
        }
        if (objectClass == Double.class) {
            long valueAsLong;
            if (value == null) {
                valueAsLong = Double.doubleToLongBits(Double.MAX_VALUE);
            } else {
                if (value.equals(Double.MAX_VALUE)) {
                    throw new RuntimeException("Sorry " + value + " is a reserved value to indicate null");
                }
                valueAsLong = Double.doubleToLongBits((Double)value);
            }
            return SerializationUtils.longToBytes(valueAsLong);
        }
        if (objectClass == Integer.class) {
            if (value == null) {
                return SerializationUtils.intToBytes(Integer.MAX_VALUE);
            }
            if (value.equals(Integer.MAX_VALUE)) {
                throw new RuntimeException("Sorry " + value + " is a reserved value to indicate null.");
            }
            return SerializationUtils.intToBytes((Integer)value);
        }
        if (objectClass == Float.class) {
            int valueAsInt;
            if (value == null) {
                valueAsInt = Float.floatToIntBits(Float.MAX_VALUE);
            } else {
                if (value.equals(Float.valueOf(Float.MAX_VALUE))) {
                    throw new RuntimeException("Sorry " + value + " is a reserved value to indicate null");
                }
                valueAsInt = Float.floatToIntBits(((Float)value).floatValue());
            }
            return SerializationUtils.intToBytes(valueAsInt);
        }
        if (objectClass == String.class) {
            if (value == null) {
                return SerializationUtils.stringToBytes(STRING_NULL);
            }
            if (value.equals(STRING_NULL)) {
                throw new RuntimeException("Sorry " + value + " is a reserved value to indicate null");
            }
            return SerializationUtils.stringToBytes((String)value);
        }
        return SerializationUtils.stringToBytes(SerializationUtils.serializeObject(value, false));
    }

    public static <T> T bytesToObjectCheckForNull(byte[] value, Class<T> objectClass) {
        if (objectClass == Long.class) {
            long response = SerializationUtils.bytesToLong(value);
            if (response != 0x7FFFFFFFFFFFFFFCL) {
                return (T)new Long(response);
            }
            return null;
        }
        if (objectClass == Double.class) {
            double response = Double.longBitsToDouble(SerializationUtils.bytesToLong(value));
            if (response != Double.MAX_VALUE) {
                return (T)new Double(response);
            }
            return null;
        }
        if (objectClass == Integer.class) {
            int response = SerializationUtils.bytesToInt(value);
            if (response != Integer.MAX_VALUE) {
                return (T)new Integer(response);
            }
            return null;
        }
        if (objectClass == Float.class) {
            float response = Float.intBitsToFloat(SerializationUtils.bytesToInt(value));
            if (response != Float.MAX_VALUE) {
                return (T)new Float(response);
            }
            return null;
        }
        String objectAsString = SerializationUtils.bytesToString(value);
        if (STRING_NULL.equals(objectAsString)) {
            return null;
        }
        if (objectClass == String.class) {
            return (T)objectAsString;
        }
        return SerializationUtils.deserializeObject(objectAsString, objectClass, new Class[0]);
    }

    public static <T> byte[] objectToBytes(T value, Class<T> objectClass) {
        if (objectClass == Long.class) {
            return SerializationUtils.longToBytes((Long)value);
        }
        if (objectClass == Double.class) {
            return SerializationUtils.longToBytes(Double.doubleToLongBits((Double)value));
        }
        if (objectClass == Integer.class) {
            return SerializationUtils.intToBytes((Integer)value);
        }
        if (objectClass == Float.class) {
            return SerializationUtils.intToBytes(Float.floatToIntBits(((Float)value).floatValue()));
        }
        if (objectClass == String.class) {
            return SerializationUtils.stringToBytes((String)value);
        }
        return SerializationUtils.stringToBytes(SerializationUtils.serializeObject(value));
    }

    public static <T> byte[] objectToCompressedBytes(T value, Class<T> objectClass) {
        try {
            return Snappy.compress((byte[])SerializationUtils.objectToBytes(value, objectClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T compressedBytesToObject(byte[] bytes, Class<T> objectClass) {
        try {
            return SerializationUtils.bytesToObject(Snappy.uncompress((byte[])bytes), objectClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static long bytesToLong(byte[] bytes) {
        if (bytes.length < 8) {
            bytes = Arrays.copyOf(bytes, 8);
        }
        long result = ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)(bytes[7] & 0xFF);
        return result;
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        int result = (bytes[0] << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        return result;
    }

    public static void writeObject(Object object, OutputStream outputStream) {
        try {
            if (object instanceof Compactable) {
                ((Compactable)object).compact();
            }
            defaultObjectMapper.writeValue(outputStream, object);
        }
        catch (IOException exp) {
            throw new RuntimeException("Failed to write object to outputstream", exp);
        }
    }

    public static <T> T readObject(Class<T> _class, InputStream inputStream) {
        try {
            return (T)defaultObjectMapper.readValue(inputStream, _class);
        }
        catch (IOException exp) {
            throw new RuntimeException("Failed to read object from inputstream", exp);
        }
    }

    public static <T> int getWidth(Class<T> objectClass) {
        if (objectClass == Long.class || objectClass == Double.class) {
            return 8;
        }
        if (objectClass == Integer.class || objectClass == Float.class) {
            return 4;
        }
        return -1;
    }

    static {
        prettyPrintObjectMapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
    }
}

