/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

public abstract class OccasionalAction<T> {
    private final long interval;
    private long previous;
    private long start;

    public OccasionalAction(long interval) {
        this.interval = interval;
        this.previous = System.currentTimeMillis();
        this.start = -1L;
    }

    public void doOccasionalAction(T curr) {
        long timeNow = System.currentTimeMillis();
        if (this.start == -1L) {
            this.start = timeNow;
        }
        if (timeNow - this.previous > this.interval) {
            this.previous = timeNow;
            this.doAction(curr);
        }
    }

    public long getStart() {
        return this.start;
    }

    protected abstract void doAction(T var1);
}

