/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NumUtils {
    public static int getBin(double[] borders, double count) {
        int bin;
        for (bin = borders.length; bin > 0 && count < borders[bin - 1]; --bin) {
        }
        return bin;
    }

    public static double[] getBorders(int numberOfBins, List<Double> counts) {
        Collections.sort(counts);
        if (!counts.isEmpty()) {
            ArrayList<Integer> borderInds = new ArrayList<Integer>();
            boolean valuesLeft = true;
            while (borderInds.size() < numberOfBins - 1 && valuesLeft) {
                int maxSizeToSplit = 0;
                int bestIndToSplit = -1;
                for (int i = 0; i < borderInds.size() + 1; ++i) {
                    int sizeOfSplit;
                    int indToSplit;
                    int endInd;
                    int startInd = i > 0 ? (Integer)borderInds.get(i - 1) : 0;
                    if (startInd >= (endInd = i < borderInds.size() ? (Integer)borderInds.get(i) : counts.size() - 1) - 1 || endInd - startInd <= maxSizeToSplit || (indToSplit = NumUtils.findBestSplit(counts, startInd, endInd)) == -1 || (sizeOfSplit = Math.min(indToSplit - startInd, endInd - indToSplit)) <= maxSizeToSplit) continue;
                    maxSizeToSplit = sizeOfSplit;
                    bestIndToSplit = indToSplit;
                }
                if (bestIndToSplit == -1) {
                    valuesLeft = false;
                    continue;
                }
                borderInds.add(bestIndToSplit);
                Collections.sort(borderInds);
            }
            double[] result = new double[borderInds.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = counts.get((Integer)borderInds.get(i));
            }
            return result;
        }
        return new double[]{0.0};
    }

    private static int findBestSplit(List<Double> counts, int startInd, int endInd) {
        int topInd;
        int middle;
        int bottomInd;
        for (bottomInd = middle = startInd + (endInd - startInd) / 2; bottomInd > startInd && counts.get(bottomInd - 1).equals(counts.get(bottomInd)); --bottomInd) {
        }
        for (topInd = middle; topInd < endInd && counts.get(topInd - 1).equals(counts.get(topInd)); ++topInd) {
        }
        if (bottomInd > startInd) {
            if (topInd < endInd) {
                int dist1 = middle - bottomInd;
                int dist2 = topInd - middle;
                if (dist1 < dist2) {
                    return bottomInd;
                }
                return topInd;
            }
            return bottomInd;
        }
        if (topInd < endInd) {
            return topInd;
        }
        return -1;
    }

    public static String fmt(double input) {
        if (Double.isNaN(input)) {
            return "NaN";
        }
        return NumUtils.fmt(input, 2);
    }

    public static String makeNicePercent(double input) {
        DecimalFormat format = new DecimalFormat("00.00");
        return format.format(input *= 100.0);
    }

    public static String fmt(double input, int digits) {
        DecimalFormat formatter = new DecimalFormat("0.###E00");
        return formatter.format(input);
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int anArray : array) {
            sum += anArray;
        }
        return sum;
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (double anArray : array) {
            sum += anArray;
        }
        return sum;
    }

    public static double sum(ArrayList<Pair<Double, Integer>> results) {
        double sum = 0.0;
        for (Pair<Double, Integer> result : results) {
            sum += result.getFirst().doubleValue();
        }
        return sum;
    }

    public static int split(int number, int start, int end) {
        return number << start >>> 32 - (end - start);
    }

    public static int join(int ... valsAndSizes) {
        if (valsAndSizes.length % 2 == 1) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        for (int i = 0; i < valsAndSizes.length; i += 2) {
            int val = valsAndSizes[i];
            int size = valsAndSizes[i + 1];
            result = result << size | val;
            if (val <= 1 << size) continue;
            throw new IllegalArgumentException("Can't represent value " + val + " with " + size + " bits.");
        }
        return result;
    }

    public static String fixedLength(long value, int numberOfDigits) {
        String result = Long.toString(value);
        while (result.length() < numberOfDigits) {
            result = "0" + result;
        }
        return result;
    }

    public static double sum(List<Double> values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum;
    }

    public static double average(List<Double> values) {
        if (values.isEmpty()) {
            throw new RuntimeException("Can not compute average of empty list!");
        }
        return NumUtils.sum(values) / (double)values.size();
    }

    public static long sumOfLongValues(List<Long> values) {
        long sum = 0L;
        for (Long value : values) {
            sum += value.longValue();
        }
        return sum;
    }

    public static double sumLogProbs(double probPos, double probNeg) {
        if (probPos > probNeg) {
            return probPos + Math.log(Math.exp(probNeg - probPos) + 1.0);
        }
        return probNeg + Math.log(Math.exp(probPos - probNeg) + 1.0);
    }

    public static double sumLogProbs(double[] probabilities) {
        double max = NumUtils.max(probabilities);
        double sum = 0.0;
        for (double probability : probabilities) {
            sum += Math.exp(probability - max);
        }
        return max + Math.log(sum);
    }

    private static double max(double[] probabilities) {
        double max = probabilities[0];
        for (int i = 1; i < probabilities.length; ++i) {
            if (!(probabilities[i] > max)) continue;
            max = probabilities[i];
        }
        return max;
    }
}

