/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.util;

import be.bagofwords.text.SimpleString;

public class HashUtils {
    public static final int startHash = 5381;
    public static final int addHash = 65599;

    public static int integerHashCode(String s) {
        int hash = 5381;
        for (int pos = 0; pos < s.length(); ++pos) {
            hash = hash * 65599 + s.charAt(pos);
        }
        return hash;
    }

    public static long hashCode(String s) {
        long hash = 5381L;
        for (int pos = 0; pos < s.length(); ++pos) {
            hash = hash * 65599L + (long)s.charAt(pos);
        }
        return hash;
    }

    public static long hashCode(String ... strings) {
        long hash = 5381L;
        for (String s : strings) {
            for (int pos = 0; pos < s.length(); ++pos) {
                hash = hash * 65599L + (long)s.charAt(pos);
            }
        }
        return hash;
    }

    public static long hashCode(SimpleString targetWord) {
        return HashUtils.hashCode(targetWord.getS());
    }

    public static long randomDistributeHash(long hash) {
        long result = 5381L;
        for (int i = 0; i < 8; ++i) {
            result = result * 65599L + (long)((byte)hash);
            hash >>= 8;
        }
        return result;
    }
}

