/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.ui;

import be.bagofwords.ui.ConsoleInputOutput;
import be.bagofwords.util.NumUtils;
import be.bagofwords.util.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public abstract class UI {
    private BufferedWriter wtr;
    private static UI object;
    private SimpleDateFormat printTimeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
    public static final boolean printCaller = false;
    public static final boolean printTime = true;
    public static final boolean printMemory = true;
    private boolean prevNewLine = true;
    private final String[] mainMethodNames = new String[]{"main", "run"};
    private final String[] methodNamesToIgnore = new String[]{"doAction", "doOccasionalAction", "trackProgress"};
    public static final Priority ERROR;
    public static final Priority WARNING;
    public static final Priority HIGH;
    public static final Priority NORMAL;
    public static final Priority LOW;
    public static final Priority DEBUG;
    private Priority outputLevel = Priority.NORMAL;

    public UI() {
        object = this;
    }

    public static UI getInstance() {
        if (object == null) {
            UI.setInstance(UI.getDefaultOutputManager());
        }
        return object;
    }

    public static void setInstance(UI ui) {
        object = ui;
    }

    public static void writeError(String msg) {
        UI.getInstance().writeLn(ERROR, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeError(String msg, Throwable e) {
        UI uI = UI.getInstance();
        synchronized (uI) {
            String[] lines;
            UI.getInstance().writeLn(ERROR, msg);
            for (String line : lines = Utils.getStackTrace(e).split("\n")) {
                UI.getInstance().writeLn(ERROR, line);
            }
        }
    }

    public static void writeWarning(String msg) {
        UI.getInstance().writeLn(WARNING, msg);
    }

    public static void writeHigh(String msg) {
        UI.getInstance().writeLn(HIGH, msg);
    }

    public static void writeNormal(String msg) {
        UI.getInstance().writeLn(NORMAL, msg);
    }

    public static void writeLow(String msg) {
        UI.getInstance().writeLn(LOW, msg);
    }

    public static void writeDebug(String msg) {
        UI.getInstance().writeLn(DEBUG, msg);
    }

    public static void write(String msg) {
        UI.writeNormal(msg);
    }

    public void writeLn(Priority priority, String msg) {
        this.write(priority, msg + "\n");
    }

    public void write(Priority priority, String msg) {
        if (UI.print(priority)) {
            if (this.prevNewLine) {
                msg = this.getTime() + " " + msg;
                msg = this.getMemory() + " " + msg;
            }
            this.prevNewLine = !msg.isEmpty() && msg.charAt(msg.length() - 1) == '\n';
            this.writeToFile(msg);
            this.writeOutput(priority, msg);
        }
    }

    private void writeToFile(String msg) {
        if (this.wtr != null) {
            try {
                this.wtr.write(msg);
                this.wtr.flush();
            }
            catch (IOException exp) {
                UI.write("Could not write to outputFile because of " + exp);
                this.wtr = null;
            }
        }
    }

    public String getMemory() {
        String mem = NumUtils.fixedLength((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L, 4) + "Mb";
        return mem;
    }

    private String getTime() {
        return this.printTimeFormat.format(new Date());
    }

    private String callingClass() {
        StackTraceElement[] els = Thread.currentThread().getStackTrace();
        int ind = 0;
        while (Arrays.binarySearch(this.mainMethodNames, els[ind].getMethodName()) < 0) {
            ++ind;
        }
        String stopAt = UI.class.getCanonicalName();
        String result = "";
        String prevClass = "";
        while (!els[ind].getClassName().equals(stopAt)) {
            if (Arrays.binarySearch(this.methodNamesToIgnore, els[ind].getMethodName()) < 0) {
                String className = "-";
                if (!els[ind].getClassName().equals(prevClass)) {
                    prevClass = els[ind].getClassName();
                    int start = prevClass.lastIndexOf(".");
                    className = prevClass.substring(start + 1);
                }
                result = result + className + ":" + els[ind].getMethodName() + ":" + els[ind].getLineNumber() + "  ";
            }
            --ind;
        }
        return result;
    }

    public static String read() {
        return UI.getInstance().readInputLine();
    }

    public static String read(String msg) {
        UI.getInstance().writeLn(NORMAL, msg);
        return UI.getInstance().readInputLine();
    }

    public static boolean readBoolean(String msg) {
        while (true) {
            UI.getInstance().writeLn(NORMAL, msg);
            String input = UI.getInstance().readInputLine();
            if (input.equalsIgnoreCase("yes")) {
                return true;
            }
            if (input.equalsIgnoreCase("1")) {
                return true;
            }
            if (input.equalsIgnoreCase("true")) {
                return true;
            }
            if (input.equalsIgnoreCase("0")) {
                return false;
            }
            if (input.equalsIgnoreCase("no")) {
                return false;
            }
            if (input.equalsIgnoreCase("false")) {
                return false;
            }
            UI.getInstance().writeLn(NORMAL, "Please enter yes, no, true, false, 0 or 1.");
        }
    }

    public static boolean readBoolean(String msg, boolean defaultValue) {
        while (true) {
            UI.getInstance().writeLn(NORMAL, msg);
            String input = UI.getInstance().readInputLine();
            if (input.equalsIgnoreCase("yes")) {
                return true;
            }
            if (input.equalsIgnoreCase("1")) {
                return true;
            }
            if (input.equalsIgnoreCase("true")) {
                return true;
            }
            if (input.equalsIgnoreCase("0")) {
                return false;
            }
            if (input.equalsIgnoreCase("no")) {
                return false;
            }
            if (input.equalsIgnoreCase("false")) {
                return false;
            }
            if (input.trim().equals("")) {
                return defaultValue;
            }
            UI.getInstance().writeLn(NORMAL, "Please enter yes, no, true, false, 0 or 1.");
        }
    }

    public static boolean readBoolean(String msg, boolean defaultVal, long timeToWait) {
        while (true) {
            UI.getInstance().writeLn(NORMAL, msg);
            String input = UI.getInstance().readInputLine(timeToWait);
            if (input == null) {
                return defaultVal;
            }
            if (input.equalsIgnoreCase("yes")) {
                return true;
            }
            if (input.equalsIgnoreCase("1")) {
                return true;
            }
            if (input.equalsIgnoreCase("true")) {
                return true;
            }
            if (input.equalsIgnoreCase("0")) {
                return false;
            }
            if (input.equalsIgnoreCase("no")) {
                return false;
            }
            if (input.equalsIgnoreCase("false")) {
                return false;
            }
            UI.getInstance().writeLn(NORMAL, "Please enter yes, no, true, false, 0 or 1.");
        }
    }

    public static int readInt(String msg) {
        while (true) {
            UI.getInstance().writeLn(NORMAL, msg);
            String input = UI.getInstance().readInputLine();
            try {
                int result = Integer.parseInt(input);
                return result;
            }
            catch (Exception exp) {
                UI.getInstance().writeLn(NORMAL, "Please enter a valid integer");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String msg) {
        while (true) {
            UI.getInstance().writeLn(NORMAL, msg);
            String input = UI.getInstance().readInputLine();
            try {
                double result = Double.parseDouble(input);
                return result;
            }
            catch (Exception exp) {
                UI.getInstance().writeLn(NORMAL, "Please enter a valid double");
                continue;
            }
            break;
        }
    }

    public abstract String readInputLine();

    public abstract String readInputLine(long var1);

    protected abstract void writeOutput(Priority var1, String var2);

    public static void writeError(Exception e) {
        UI.writeError("", e);
    }

    public static void writeStackTrace(String message) {
        UI.write(message);
        UI.write(Utils.getStackTrace(new RuntimeException("Dummy")));
    }

    private static UI getDefaultOutputManager() {
        try {
            ConsoleInputOutput ui = new ConsoleInputOutput();
            ui.setOutputLevel(NORMAL);
            return ui;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean print(Priority priority) {
        if (UI.getInstance().getOutputLevel() == Priority.NONE) {
            return false;
        }
        return UI.getInstance().getOutputLevel().compareTo(priority) >= 0;
    }

    public void setOutputLevel(Priority p) {
        this.outputLevel = p;
    }

    public Priority getOutputLevel() {
        return this.outputLevel;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.wtr.flush();
        this.wtr.close();
    }

    public static String getMemoryUsage() {
        return UI.getInstance().getMemory();
    }

    public static void write(Object obj) {
        if (obj == null) {
            UI.write("null");
        } else {
            UI.write(obj.toString());
        }
    }

    public static void write() {
        UI.write("");
    }

    static {
        ERROR = Priority.ERROR;
        WARNING = Priority.WARNING;
        HIGH = Priority.HIGH;
        NORMAL = Priority.NORMAL;
        LOW = Priority.LOW;
        DEBUG = Priority.DEBUG;
    }

    public static enum Priority {
        NONE,
        ERROR,
        WARNING,
        HIGH,
        NORMAL,
        LOW,
        DEBUG;

    }
}

