/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.text;

import be.bagofwords.text.ExtendedString;
import be.bagofwords.util.Direction;
import java.util.Set;

public class WordIterator {
    public static final int MAX_LENGTH_OF_WORD = 100;
    private static final char FULL_STOP = '.';
    private ExtendedString nextWord;
    private int pos;
    private final char[] data;
    private final Set<String> wordsWithPunct;

    public WordIterator(String text, Set<String> wordsWithPunct) {
        this(text.toCharArray(), wordsWithPunct);
    }

    public WordIterator(char[] data, Set<String> wordsWithPunct) {
        this.data = data;
        this.pos = 0;
        this.wordsWithPunct = wordsWithPunct;
        this.findNextWord();
    }

    private void findNextWord() {
        this.nextWord = WordIterator.findWord(this.data, this.pos, Direction.Right, this.wordsWithPunct);
        if (this.nextWord != null) {
            this.pos = this.nextWord.end;
        }
    }

    public static ExtendedString findWord(char[] data, int startOfSearch, Direction direction, Set<String> wordsWithPunct) {
        ExtendedString nextWord = WordIterator.findWord(data, startOfSearch, direction, true);
        if (nextWord != null && WordIterator.containsNonLetterOrNumber(nextWord)) {
            if (wordsWithPunct.contains(nextWord.toString())) {
                return nextWord;
            }
            return WordIterator.findWord(data, startOfSearch, direction, false);
        }
        return nextWord;
    }

    private static boolean containsNonLetterOrNumber(ExtendedString nextWord) {
        for (int i = 0; i < nextWord.length(); ++i) {
            if (Character.isLetterOrDigit(nextWord.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static ExtendedString findWord(char[] data, int startOfSearch, Direction direction, boolean allowPossibleWordChars) {
        int pos;
        if (direction == Direction.Right) {
            for (pos = startOfSearch; pos < data.length && WordIterator.isNonWordChar(data[pos], false); ++pos) {
            }
            int start = pos;
            while (pos - start < 100 && pos < data.length && !WordIterator.isNonWordChar(data[pos], allowPossibleWordChars)) {
                ++pos;
            }
            if (start < pos) {
                ExtendedString result = new ExtendedString(data, start, pos);
                return result;
            }
            return null;
        }
        --pos;
        while (pos >= 0 && WordIterator.isNonWordChar(data[pos], false)) {
            --pos;
        }
        int start = pos;
        while (start - pos < 100 && pos >= 0 && !WordIterator.isNonWordChar(data[pos], allowPossibleWordChars)) {
            --pos;
        }
        if (start > pos) {
            return new ExtendedString(data, pos + 1, start + 1);
        }
        return null;
    }

    public static boolean isNonWordChar(char c, boolean allowPossibleWordChars) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        return !allowPossibleWordChars || c != '.';
    }

    public boolean hasNext() {
        return this.nextWord != null;
    }

    public ExtendedString next() {
        ExtendedString result = this.nextWord;
        this.findNextWord();
        return result;
    }

    public void reset() {
        this.pos = 0;
        this.findNextWord();
    }
}

